/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.world;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.ILabelElement;
import de.sanandrew.mods.turretmod.api.client.tcu.ILabelRegistry;
import de.sanandrew.mods.turretmod.client.event.ClientTickHandler;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableFloat;

@SideOnly(value=Side.CLIENT)
public final class RenderTurretPointed
implements ILabelRegistry {
    public static final RenderTurretPointed INSTANCE = new RenderTurretPointed();
    private final WeakHashMap<EntityTurret, LabelEntry> labels = new WeakHashMap();
    private final List<ILabelElement> elements = new ArrayList<ILabelElement>();
    private static final float FADE_TIME = 2.0f;

    public void render(Minecraft mc, double x, double y, double z, double partTicks) {
        if (mc.field_71439_g != mc.func_175606_aa()) {
            return;
        }
        this.labels.forEach((turret, tp) -> {
            tp.wasActive = tp.active;
            tp.active = false;
            if (tp.wasActive) {
                tp.endTick = ClientTickHandler.ticksInGame;
            }
        });
        if (mc.field_147125_j instanceof EntityTurret) {
            EntityTurret turret2 = (EntityTurret)mc.field_147125_j;
            RenderTurretPointed.renderTurretBB(turret2, x, y, z);
            if (RenderTurretPointed.isItemTCU(mc.field_71439_g.func_184614_ca()) || RenderTurretPointed.isItemTCU(mc.field_71439_g.func_184592_cb())) {
                LabelEntry tp2 = this.labels.computeIfAbsent(turret2, t -> new LabelEntry(mc.func_175598_ae()));
                tp2.active = true;
                if (!tp2.wasActive) {
                    tp2.beginTick = tp2.endTick < 0L ? (long)ClientTickHandler.ticksInGame : tp2.endTick;
                }
            }
        }
        this.cleanupRenderers(false);
        this.labels.forEach((turret, lbl) -> {
            if (turret != null) {
                boolean lblActive = lbl.active;
                lbl.angleY += (-mc.func_175598_ae().field_78735_i - lbl.angleY) / 16.0f;
                lbl.angleX += (mc.func_175598_ae().field_78732_j - lbl.angleX) / 16.0f;
                if (lblActive) {
                    if (lbl.progress < 2.0f) {
                        lbl.progress = ((float)((long)ClientTickHandler.ticksInGame - lbl.beginTick) + (float)partTicks) / 2.0f;
                    }
                } else if (lbl.progress > 0.0f) {
                    lbl.progress = ((float)lbl.endTick + 4.0f - (float)ClientTickHandler.ticksInGame - (float)partTicks) / 2.0f;
                    lblActive = true;
                }
                if (lblActive) {
                    double entityX = turret.field_70142_S + (turret.field_70165_t - turret.field_70142_S) * partTicks;
                    double entityY = turret.field_70137_T + (turret.field_70163_u - turret.field_70137_T) * partTicks;
                    double entityZ = turret.field_70136_U + (turret.field_70161_v - turret.field_70136_U) * partTicks;
                    this.renderLabel((EntityTurret)turret, entityX - x, entityY - y, entityZ - z, (LabelEntry)lbl);
                }
            }
        });
    }

    @Override
    public void registerLabelElement(ILabelElement element) {
        Objects.requireNonNull(element);
        this.elements.add(element);
    }

    public void cleanupRenderers(boolean clearAll) {
        if (clearAll) {
            this.labels.clear();
        } else {
            this.labels.entrySet().removeIf(entry -> entry.getValue() != null && !((LabelEntry)entry.getValue()).active && ((LabelEntry)entry.getValue()).progress <= 0.0f);
        }
    }

    private static boolean isItemTCU(ItemStack stack) {
        return ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_CONTROL_UNIT);
    }

    private void renderLabel(EntityTurret turret, double x, double y, double z, LabelEntry lbl) {
        MutableFloat currHeight;
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontrenderer = mc.field_71466_p;
        float scale = 0.01f;
        List<ILabelElement> fltElem = this.elements.stream().filter(el -> el.showElement(turret)).sorted((el1, el2) -> Integer.compare(el2.getPriority(), el1.getPriority())).collect(Collectors.toList());
        lbl.maxWidth = fltElem.stream().collect(() -> new MutableFloat(128.0f), (f, l) -> f.setValue(Math.max(f.getValue().floatValue(), l.getWidth(turret, fontrenderer))), (f1, f2) -> f1.setValue(Math.max(f1.getValue().floatValue(), f2.getValue().floatValue()))).floatValue();
        lbl.maxHeight = fltElem.stream().collect(() -> new MutableFloat(0.0f), (f, l) -> f.add(l.getHeight(turret, fontrenderer)), (f1, f2) -> f1.add((Number)f2.getValue())).floatValue();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)(y + (double)(turret.isUpsideDown() ? 1.4f : 0.7f)), (double)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)lbl.angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)lbl.angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.01f, (float)-0.01f, (float)0.01f);
        GlStateManager.func_179137_b((double)((double)(-lbl.maxWidth) / 2.0), (double)-32.0, (double)0.0);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        float alphaMulti = Math.min(1.0f, lbl.progress);
        ColorObj clrTop = new ColorObj(0x50FF00 | Math.max(Math.round(204.0f * alphaMulti), 4) << 24);
        ColorObj clrBottom = new ColorObj(0x288000 | Math.max(Math.round(204.0f * alphaMulti), 4) << 24);
        ColorObj clrMain = new ColorObj(0x1000 | Math.max(Math.round(160.0f * alphaMulti), 4) << 24);
        RenderTurretPointed.addQuad(buffer, -2.0, -2.0, (double)lbl.maxWidth + 2.0, (double)lbl.maxHeight + 2.0, clrMain);
        RenderTurretPointed.addQuad(buffer, -3.0, -3.0, (double)lbl.maxWidth + 3.0, -2.0, clrTop);
        RenderTurretPointed.addQuad(buffer, -3.0, (double)lbl.maxHeight + 2.0, (double)lbl.maxWidth + 3.0, (double)lbl.maxHeight + 3.0, clrBottom);
        RenderTurretPointed.addQuad(buffer, -3.0, -2.0, -2.0, (double)lbl.maxHeight + 2.0, clrTop, clrBottom);
        RenderTurretPointed.addQuad(buffer, (double)lbl.maxWidth + 2.0, -2.0, (double)lbl.maxWidth + 3.0, (double)lbl.maxHeight + 2.0, clrTop, clrBottom);
        RenderTurretPointed.addQuad(buffer, -3.0, -4.0, (double)lbl.maxWidth + 3.0, -3.0, clrMain);
        RenderTurretPointed.addQuad(buffer, -3.0, (double)lbl.maxHeight + 3.0, (double)lbl.maxWidth + 3.0, (double)lbl.maxHeight + 4.0, clrMain);
        RenderTurretPointed.addQuad(buffer, -4.0, -3.0, -3.0, (double)lbl.maxHeight + 3.0, clrMain);
        RenderTurretPointed.addQuad(buffer, (double)lbl.maxWidth + 3.0, -3.0, (double)lbl.maxWidth + 4.0, (double)lbl.maxHeight + 3.0, clrMain);
        if (lbl.progress >= 1.0f) {
            currHeight = new MutableFloat(0.0f);
            fltElem.forEach(elem -> {
                elem.doRenderQuads(turret, lbl.maxWidth, lbl.progress - 1.0f, fontrenderer, currHeight.floatValue(), buffer);
                currHeight.add(elem.getHeight(turret, fontrenderer));
            });
        }
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        if (lbl.progress >= 1.0f) {
            currHeight = new MutableFloat(0.0f);
            fltElem.forEach(elem -> {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)currHeight.floatValue(), (float)0.0f);
                elem.doRenderTextured(turret, lbl.maxWidth, lbl.progress - 1.0f, fontrenderer);
                GlStateManager.func_179121_F();
                currHeight.add(elem.getHeight(turret, fontrenderer));
            });
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void renderTurretBB(EntityTurret turret, double renderX, double renderY, double renderZ) {
        AxisAlignedBB renderBB = turret.func_174813_aQ().func_72317_d(-renderX, -renderY, -renderZ);
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer buf = tess.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_187441_d((float)1.0f);
        buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        RenderTurretPointed.addLine(buf, renderBB.field_72340_a, renderBB.field_72338_b, renderBB.field_72339_c, renderBB.field_72340_a, renderBB.field_72337_e, renderBB.field_72339_c, new ColorObj(-16777216));
        RenderTurretPointed.addLine(buf, renderBB.field_72336_d, renderBB.field_72337_e, renderBB.field_72339_c, renderBB.field_72336_d, renderBB.field_72338_b, renderBB.field_72339_c, new ColorObj(-16777216));
        RenderTurretPointed.addLine(buf, renderBB.field_72336_d, renderBB.field_72338_b, renderBB.field_72334_f, renderBB.field_72336_d, renderBB.field_72337_e, renderBB.field_72334_f, new ColorObj(-16777216));
        RenderTurretPointed.addLine(buf, renderBB.field_72340_a, renderBB.field_72337_e, renderBB.field_72334_f, renderBB.field_72340_a, renderBB.field_72338_b, renderBB.field_72334_f, new ColorObj(-16777216));
        RenderTurretPointed.addLine(buf, renderBB.field_72340_a, renderBB.field_72338_b, renderBB.field_72339_c, renderBB.field_72340_a, renderBB.field_72337_e, renderBB.field_72339_c, new ColorObj(-16777216));
        RenderTurretPointed.addLine(buf, renderBB.field_72340_a, renderBB.field_72337_e, renderBB.field_72334_f, renderBB.field_72340_a, renderBB.field_72338_b, renderBB.field_72334_f, new ColorObj(-16777216));
        RenderTurretPointed.addLine(buf, renderBB.field_72336_d, renderBB.field_72338_b, renderBB.field_72334_f, renderBB.field_72336_d, renderBB.field_72337_e, renderBB.field_72334_f, new ColorObj(-16777216));
        RenderTurretPointed.addLine(buf, renderBB.field_72336_d, renderBB.field_72337_e, renderBB.field_72339_c, renderBB.field_72336_d, renderBB.field_72338_b, renderBB.field_72339_c, new ColorObj(-16777216));
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    private static void addLine(VertexBuffer buf, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, ColorObj clr) {
        buf.func_181662_b(minX, minY, minZ).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
        buf.func_181662_b(maxX, maxY, maxZ).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
    }

    private static void addQuad(VertexBuffer buf, double minX, double minY, double maxX, double maxY, ColorObj clr1, ColorObj clr2) {
        buf.func_181662_b(minX, minY, 0.0).func_181666_a(clr1.fRed(), clr1.fGreen(), clr1.fBlue(), clr1.fAlpha()).func_181675_d();
        buf.func_181662_b(minX, maxY, 0.0).func_181666_a(clr2.fRed(), clr2.fGreen(), clr2.fBlue(), clr2.fAlpha()).func_181675_d();
        buf.func_181662_b(maxX, maxY, 0.0).func_181666_a(clr2.fRed(), clr2.fGreen(), clr2.fBlue(), clr2.fAlpha()).func_181675_d();
        buf.func_181662_b(maxX, minY, 0.0).func_181666_a(clr1.fRed(), clr1.fGreen(), clr1.fBlue(), clr1.fAlpha()).func_181675_d();
    }

    private static void addQuad(VertexBuffer buf, double minX, double minY, double maxX, double maxY, ColorObj clr) {
        RenderTurretPointed.addQuad(buf, minX, minY, maxX, maxY, clr, clr);
    }

    private static class LabelEntry {
        protected long beginTick = -1L;
        protected long endTick = -1L;
        protected boolean wasActive = false;
        protected boolean active = true;
        protected float angleY;
        protected float angleX;
        protected float maxHeight;
        protected float maxWidth;
        protected float progress;

        protected LabelEntry(RenderManager rMan) {
            this.angleY = -rMan.field_78735_i;
            this.angleX = rMan.field_78732_j;
            this.maxWidth = 128.0f;
            this.maxHeight = 0.0f;
            this.progress = 0.0f;
        }
    }
}

