/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.util;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.audio.SoundLaser;
import de.sanandrew.mods.turretmod.client.event.ClientTickHandler;
import de.sanandrew.mods.turretmod.client.event.RenderEventHandler;
import de.sanandrew.mods.turretmod.client.event.RenderForcefieldHandler;
import de.sanandrew.mods.turretmod.client.gui.GuiCameras;
import de.sanandrew.mods.turretmod.client.gui.GuiPotatoGenerator;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiAssemblyFilter;
import de.sanandrew.mods.turretmod.client.gui.assembly.GuiTurretAssembly;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.PlayerHeads;
import de.sanandrew.mods.turretmod.client.gui.tinfo.GuiTurretInfo;
import de.sanandrew.mods.turretmod.client.gui.tinfo.TurretInfoCategoryRegistry;
import de.sanandrew.mods.turretmod.client.particle.ParticleAssemblySpark;
import de.sanandrew.mods.turretmod.client.particle.ParticleCryoTrail;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderBullet;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderFlame;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderNothingness;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderPebble;
import de.sanandrew.mods.turretmod.client.render.projectile.RenderTurretArrow;
import de.sanandrew.mods.turretmod.client.render.turret.RenderTurret;
import de.sanandrew.mods.turretmod.client.render.world.RenderTurretPointed;
import de.sanandrew.mods.turretmod.client.util.ModelRegistry;
import de.sanandrew.mods.turretmod.client.util.ShaderHelper;
import de.sanandrew.mods.turretmod.client.world.ClientWorldEventListener;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileBullet;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileCrossbowBolt;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileCryoCell;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileFlame;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileLaser;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileMinigunPebble;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectilePebble;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.turret.GuiTcuRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretLaser;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.TileEntityElectrolyteGenerator;
import de.sanandrew.mods.turretmod.util.CommonProxy;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientWorldEventListener());
        RenderingRegistry.registerEntityRenderingHandler(EntityTurret.class, RenderTurret::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileCrossbowBolt.class, RenderTurretArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileCryoCell.class, RenderNothingness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectilePebble.class, RenderPebble::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileBullet.class, RenderBullet::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileMinigunPebble.class, RenderPebble::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileLaser.class, RenderNothingness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileFlame.class, RenderFlame::new);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ModelRegistry.registerModelPre112();
        TurretModRebirth.PLUGINS.forEach(plugin -> plugin.registerTcuGuis(GuiTcuRegistry.INSTANCE));
        TurretModRebirth.PLUGINS.forEach(plugin -> plugin.registerTcuLabelElements(RenderTurretPointed.INSTANCE));
        MinecraftForge.EVENT_BUS.register((Object)RenderForcefieldHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        ShaderHelper.initShaders();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        TurretModRebirth.PLUGINS.forEach(plugin -> plugin.registerTurretInfoCategories(TurretInfoCategoryRegistry.INSTANCE));
        PlayerHeads.preLoadPlayerHeadsAsync();
    }

    @Override
    public void openGui(EntityPlayer player, EnumGui id, int x, int y, int z) {
        if (player == null) {
            player = Minecraft.func_71410_x().field_71439_g;
        }
        super.openGui(player, id, x, y, z);
    }

    @Override
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= 0 && id < EnumGui.VALUES.length) {
            switch (EnumGui.VALUES[id]) {
                case GUI_TCU: {
                    Entity e = world.func_73045_a(x);
                    if (!(e instanceof ITurretInst)) break;
                    return GuiTcuRegistry.INSTANCE.openGUI(y, player, (ITurretInst)e);
                }
                case GUI_TASSEMBLY_MAN: {
                    TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                    if (!(te instanceof TileEntityTurretAssembly)) break;
                    return new GuiTurretAssembly(player.field_71071_by, (TileEntityTurretAssembly)te);
                }
                case GUI_TASSEMBLY_FLT: {
                    ItemStack stack = player.func_184614_ca();
                    if (!ItemStackUtils.isValid((ItemStack)stack) || stack.func_77973_b() != ItemRegistry.ASSEMBLY_UPG_FILTER) break;
                    return new GuiAssemblyFilter(player.field_71071_by, stack);
                }
                case GUI_POTATOGEN: {
                    TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                    if (te instanceof TileEntityElectrolyteGenerator) {
                        return new GuiPotatoGenerator(player.field_71071_by, (TileEntityElectrolyteGenerator)te);
                    }
                }
                case GUI_TINFO: {
                    return new GuiTurretInfo(x, y);
                }
                case GUI_DEBUG_CAMERA: {
                    return new GuiCameras(world.func_73045_a(x));
                }
            }
        } else {
            TmrConstants.LOG.log(Level.WARN, "Gui ID %d cannot be opened as it isn't a valid index in EnumGui!", new Object[]{id});
        }
        return null;
    }

    @Override
    public void spawnParticle(EnumParticle particle, double x, double y, double z, Tuple data) {
        Minecraft mc = Minecraft.func_71410_x();
        switch (particle) {
            case ASSEMBLY_SPARK: {
                mc.field_71452_i.func_78873_a((Particle)new ParticleAssemblySpark((World)mc.field_71441_e, x, y, z, 0.0, 0.0, 0.0));
                break;
            }
            case SHOTGUN_SHOT: {
                float rotXZ = -((Float)data.getValue(0)).floatValue() / 180.0f * (float)Math.PI;
                float rotY = -((Float)data.getValue(1)).floatValue() / 180.0f * (float)Math.PI - 0.1f;
                boolean isUpsideDown = (Boolean)data.getValue(2);
                double yShift = Math.sin(rotY *= isUpsideDown ? -1.0f : 1.0f) * (double)0.6f;
                double xShift = Math.sin(rotXZ *= isUpsideDown ? -1.0f : 1.0f) * (double)0.6f * Math.cos(rotY);
                double zShift = Math.cos(rotXZ) * (double)0.6f * Math.cos(rotY);
                xShift *= isUpsideDown ? -1.0 : 1.0;
                zShift *= isUpsideDown ? -1.0 : 1.0;
                y -= isUpsideDown ? 1.0 : 0.0;
                for (int i = 0; i < 8; ++i) {
                    double xDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    double yDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    double zDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    Particle fx = new ParticleSmokeNormal.Factory().func_178902_a(0, (World)mc.field_71441_e, x + xShift, y + yShift, z + zShift, xShift * (double)0.1f + xDist, yShift * (double)0.1f + yDist, zShift * (double)0.1f + zDist, new int[0]);
                    mc.field_71452_i.func_78873_a(fx);
                }
                break;
            }
            case CRYO_PARTICLE: {
                int max = 10;
                for (int i = 0; i < max; ++i) {
                    double diffMotionX = (Double)data.getValue(0) / (double)max;
                    double diffMotionY = (Double)data.getValue(1) / (double)max;
                    double diffMotionZ = (Double)data.getValue(2) / (double)max;
                    double partMotionX = diffMotionX + MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    double partMotionY = -MiscUtils.RNG.randomDouble() * 0.025;
                    double partMotionZ = diffMotionZ + MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    mc.field_71452_i.func_78873_a((Particle)new ParticleCryoTrail((World)mc.field_71441_e, x - diffMotionX * (double)i, y - diffMotionY * (double)i, z - diffMotionZ * (double)i, partMotionX, partMotionY, partMotionZ));
                }
                break;
            }
            case MINIGUN_SHOT: {
                boolean isLeft = (Boolean)data.getValue(3);
                float shift = (isLeft ? 45.0f : -45.0f) / 180.0f * (float)Math.PI;
                float rotXZ = -((Float)data.getValue(0)).floatValue() / 180.0f * (float)Math.PI;
                float rotY = -((Float)data.getValue(1)).floatValue() / 180.0f * (float)Math.PI - 0.1f;
                boolean isUpsideDown = (Boolean)data.getValue(2);
                double motionX = Math.sin(rotXZ *= isUpsideDown ? -1.0f : 1.0f) * (double)0.06f * Math.cos(rotY *= isUpsideDown ? -1.0f : 1.0f) * (double)(isUpsideDown ? -1.0f : 1.0f);
                double motionY = Math.sin(rotY) * (double)0.06f;
                double motionZ = Math.cos(rotXZ) * (double)0.06f * Math.cos(rotY) * (double)(isUpsideDown ? -1.0f : 1.0f);
                x += Math.sin(rotXZ + shift) * (double)0.7f * Math.cos(rotY) * (double)(isUpsideDown ? -1.0f : 1.0f);
                y += Math.sin(rotY) * (double)0.6f - (double)(isUpsideDown ? 1.0f : 0.0f);
                z += Math.cos(rotXZ + shift) * (double)0.7f * Math.cos(rotY) * (double)(isUpsideDown ? -1.0f : 1.0f);
                for (int i = 0; i < 8; ++i) {
                    double xDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    double yDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    double zDist = MiscUtils.RNG.randomDouble() * 0.05 - 0.025;
                    Particle fx = new ParticleSmokeNormal.Factory().func_178902_a(0, (World)mc.field_71441_e, x, y, z, motionX + xDist, motionY + yDist, motionZ + zDist, new int[0]);
                    mc.field_71452_i.func_78873_a(fx);
                }
                break;
            }
        }
    }

    @Override
    public void playTurretLaser(ITurretInst turretInst) {
        TurretLaser.MyRAM ram = turretInst.getRAM(TurretLaser.MyRAM::new);
        if (ram.laserSound == null) {
            if (turretInst.getTargetProcessor().isShooting() && turretInst.getTargetProcessor().hasAmmo()) {
                ram.laserSound = new SoundLaser(turretInst);
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)ram.laserSound);
            }
        } else if (ram.laserSound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)ram.laserSound)) {
            ram.laserSound = null;
        }
    }

    @Override
    public void addForcefield(Entity e, IForcefieldProvider provider) {
        RenderForcefieldHandler.INSTANCE.addForcefieldRenderer(e, provider);
    }

    @Override
    public boolean hasForcefield(Entity e, Class<? extends IForcefieldProvider> providerCls) {
        return RenderForcefieldHandler.INSTANCE.hasForcefield(e, providerCls);
    }
}

