/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.util;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.repairkit.TurretRepairKit;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.block.BlockRegistry;
import de.sanandrew.mods.turretmod.client.render.tileentity.RenderElectrolyteGenerator;
import de.sanandrew.mods.turretmod.client.render.tileentity.RenderTurretAssembly;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.repairkit.RepairKitRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import de.sanandrew.mods.turretmod.tileentity.electrolytegen.TileEntityElectrolyteGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class ModelRegistry {
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) throws Exception {
        ModelRegistry.setStandardModel(ItemRegistry.TURRET_CONTROL_UNIT);
        ModelRegistry.setStandardModel(ItemRegistry.TURRET_INFO);
        ModelRegistry.setStandardModel(ItemRegistry.ASSEMBLY_UPG_FILTER);
        ModelRegistry.setStandardModel(ItemRegistry.ASSEMBLY_UPG_AUTO);
        ModelRegistry.setStandardModel(ItemRegistry.ASSEMBLY_UPG_SPEED);
        ModelRegistry.setStandardModel(BlockRegistry.ELECTROLYTE_GENERATOR);
        ModelRegistry.setStandardModel((Block)BlockRegistry.TURRET_ASSEMBLY);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurretAssembly.class, (TileEntitySpecialRenderer)new RenderTurretAssembly());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityElectrolyteGenerator.class, (TileEntitySpecialRenderer)new RenderElectrolyteGenerator());
    }

    public static void registerModelPre112() {
        ModelRegistry.setCustomMeshModel(ItemRegistry.TURRET_PLACER, new MeshDefUUID.Turret());
        ModelRegistry.setCustomMeshModel(ItemRegistry.TURRET_AMMO, new MeshDefUUID.Ammo());
        ModelRegistry.setCustomMeshModel(ItemRegistry.TURRET_UPGRADE, new MeshDefUUID.Upgrade());
        ModelRegistry.setCustomMeshModel(ItemRegistry.REPAIR_KIT, new MeshDefUUID.Repkit());
    }

    private static void setStandardModel(Item item) {
        ResourceLocation regName = item.getRegistryName();
        if (regName != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(regName, "inventory"));
        }
    }

    private static void setStandardModel(Block item) {
        if (item != Blocks.field_150350_a) {
            ModelRegistry.setStandardModel(Item.func_150898_a((Block)item));
        }
    }

    private static void setCustomMeshModel(Item item, MeshDefUUID<?> mesher) {
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178080_a(item, mesher);
        ModelLoader.setCustomMeshDefinition((Item)item, mesher);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])mesher.getResLocations());
    }

    private static abstract class MeshDefUUID<T>
    implements ItemMeshDefinition {
        public final Map<UUID, ModelResourceLocation> modelRes = new HashMap<UUID, ModelResourceLocation>();

        private MeshDefUUID() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            T type = this.getType(stack);
            ResourceLocation regName = stack.func_77973_b().getRegistryName();
            if (regName != null) {
                return type != null ? this.modelRes.get(this.getId(type)) : new ModelResourceLocation(regName, "inventory");
            }
            return null;
        }

        public abstract T getType(ItemStack var1);

        public abstract UUID getId(T var1);

        public ResourceLocation[] getResLocations() {
            return (ResourceLocation[])this.modelRes.values().toArray(new ModelResourceLocation[this.modelRes.size()]);
        }

        static final class Repkit
        extends MeshDefUUID<TurretRepairKit> {
            public Repkit() {
                for (TurretRepairKit kit : RepairKitRegistry.INSTANCE.getRegisteredTypes()) {
                    ModelResourceLocation modelRes = new ModelResourceLocation(kit.getModel(), "inventory");
                    this.modelRes.put(RepairKitRegistry.INSTANCE.getTypeId(kit), modelRes);
                }
            }

            @Override
            public TurretRepairKit getType(ItemStack stack) {
                return RepairKitRegistry.INSTANCE.getType(stack);
            }

            @Override
            public UUID getId(TurretRepairKit type) {
                return RepairKitRegistry.INSTANCE.getTypeId(type);
            }
        }

        static final class Upgrade
        extends MeshDefUUID<ITurretUpgrade> {
            public Upgrade() {
                for (ITurretUpgrade upg : UpgradeRegistry.INSTANCE.getUpgrades()) {
                    ModelResourceLocation modelRes = new ModelResourceLocation(upg.getModel(), "inventory");
                    this.modelRes.put(UpgradeRegistry.INSTANCE.getUpgradeId(upg), modelRes);
                }
            }

            @Override
            public ITurretUpgrade getType(ItemStack stack) {
                return UpgradeRegistry.INSTANCE.getUpgrade(stack);
            }

            @Override
            public UUID getId(ITurretUpgrade type) {
                return UpgradeRegistry.INSTANCE.getUpgradeId(type);
            }
        }

        static final class Ammo
        extends MeshDefUUID<IAmmunition> {
            public Ammo() {
                for (IAmmunition ammo : AmmunitionRegistry.INSTANCE.getRegisteredTypes()) {
                    ModelResourceLocation modelRes = new ModelResourceLocation(ammo.getModel(), "inventory");
                    this.modelRes.put(ammo.getId(), modelRes);
                }
            }

            @Override
            public IAmmunition getType(ItemStack stack) {
                return AmmunitionRegistry.INSTANCE.getType(stack);
            }

            @Override
            public UUID getId(IAmmunition type) {
                return type.getId();
            }
        }

        static final class Turret
        extends MeshDefUUID<ITurret> {
            Turret() {
                for (ITurret info : TurretRegistry.INSTANCE.getTurrets()) {
                    ModelResourceLocation modelRes = new ModelResourceLocation(info.getItemModel(), "inventory");
                    this.modelRes.put(info.getId(), modelRes);
                }
            }

            @Override
            public ITurret getType(ItemStack stack) {
                return TurretRegistry.INSTANCE.getTurret(stack);
            }

            @Override
            public UUID getId(ITurret type) {
                return type.getId();
            }
        }
    }
}

