/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.projectile;

import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.mutable.MutableFloat;

public class EntityProjectileLaser
extends EntityTurretProjectile {
    private int prevMaxHurtResistantTime;

    public EntityProjectileLaser(World world) {
        super(world);
    }

    public EntityProjectileLaser(World world, Entity shooter, Entity target) {
        super(world, shooter, target);
    }

    public EntityProjectileLaser(World world, Entity shooter, Vec3d shootingVec) {
        super(world, shooter, shootingVec);
    }

    @Override
    public float getArc() {
        return 0.0f;
    }

    @Override
    public float getInitialSpeedMultiplier() {
        return 20.0f;
    }

    @Override
    public float getDamage() {
        return 1.5f;
    }

    @Override
    public float getKnockbackStrengthH() {
        return 0.0f;
    }

    @Override
    public float getKnockbackStrengthV() {
        return 0.0f;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return SoundEvents.field_187646_bt;
    }

    @Override
    public DamageSource getProjDamageSource(Entity hitEntity) {
        EntityDamageSourceIndirect dmg = new EntityDamageSourceIndirect("thrown", (Entity)this, (Entity)(this.shooterCache == null ? this : this.shooterCache));
        if (!(this.shooterCache instanceof ITurretInst) || !((ITurretInst)this.shooterCache).getUpgradeProcessor().hasUpgrade(Upgrades.ENDER_MEDIUM)) {
            dmg.func_76361_j();
        }
        return dmg;
    }

    @Override
    public boolean onPreHit(Entity e, DamageSource dmgSource, MutableFloat dmg) {
        if (super.onPreHit(e, dmgSource, dmg)) {
            if (e instanceof EntityLivingBase) {
                EntityLivingBase elb = (EntityLivingBase)e;
                if (!(this.shooterCache instanceof ITurretInst) || !((ITurretInst)this.shooterCache).getUpgradeProcessor().hasUpgrade(Upgrades.ENDER_MEDIUM)) {
                    if (elb.func_70045_F()) {
                        return false;
                    }
                } else if (!elb.func_70045_F()) {
                    dmg.setValue(dmg.floatValue() * 1.25f);
                }
                this.prevMaxHurtResistantTime = elb.field_70771_an;
                elb.field_70771_an = 10;
            }
            return true;
        }
        return false;
    }

    @Override
    public void onPostHit(Entity e, DamageSource dmgSource) {
        super.onPostHit(e, dmgSource);
        if (e instanceof EntityLivingBase) {
            ((EntityLivingBase)e).field_70771_an = this.prevMaxHurtResistantTime;
            e.func_70015_d(2);
        }
    }
}

