/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.projectile;

import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityTurretProjectile;
import de.sanandrew.mods.turretmod.registry.turret.TurretMinigun;
import de.sanandrew.mods.turretmod.util.Sounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityProjectileMinigunPebble
extends EntityTurretProjectile {
    public EntityProjectileMinigunPebble(World world) {
        super(world);
    }

    public EntityProjectileMinigunPebble(World world, Entity shooter, Entity target) {
        super(world, shooter, target);
        if (shooter instanceof ITurretInst) {
            ITurretInst turret = (ITurretInst)shooter;
            TurretMinigun.MyRAM ram = turret.getRAM(TurretMinigun.MyRAM::new);
            float shift = (ram.isLeftShot ? 45.0f : -45.0f) / 180.0f * (float)Math.PI;
            float rotXZ = -turret.getEntity().field_70759_as / 180.0f * (float)Math.PI;
            float rotY = -(turret.getEntity().field_70125_A - 7.5f) / 180.0f * (float)Math.PI - 0.1f;
            boolean isUpsideDown = turret.isUpsideDown();
            this.field_70165_t += Math.sin(rotXZ + shift) * (double)0.7f * Math.cos(rotY) * (double)(isUpsideDown ? -1.0f : 1.0f);
            this.field_70163_u += Math.sin(rotY) * (double)0.6f * (double)(isUpsideDown ? -1.0f : 1.0f) - (double)(isUpsideDown ? 1.0f : 0.0f);
            this.field_70161_v += Math.cos(rotXZ + shift) * (double)0.7f * Math.cos(rotY) * (double)(isUpsideDown ? -1.0f : 1.0f);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public EntityProjectileMinigunPebble(World world, Entity shooter, Vec3d shootingVec) {
        super(world, shooter, shootingVec);
    }

    @Override
    public float getArc() {
        return 0.001f;
    }

    @Override
    public SoundEvent getRicochetSound() {
        return Sounds.RICOCHET_BULLET;
    }

    @Override
    public float getInitialSpeedMultiplier() {
        return 3.0f;
    }

    @Override
    public float getDamage() {
        return 0.3f;
    }

    @Override
    public float getKnockbackStrengthH() {
        return 0.0f;
    }

    @Override
    public float getKnockbackStrengthV() {
        return 0.0f;
    }

    @Override
    public double getScatterValue() {
        return 0.01;
    }

    @Override
    public void onPostHit(Entity e, DamageSource dmgSource) {
        super.onPostHit(e, dmgSource);
        if (e instanceof EntityLivingBase) {
            ((EntityLivingBase)e).field_70172_ad = 0;
        }
    }
}

