/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.projectile;

import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.mutable.MutableFloat;

public abstract class EntityTurretProjectile
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    protected UUID shooterUUID;
    protected Entity shooterCache;
    protected UUID targetUUID;
    protected Entity targetCache;
    protected double maxDist;

    public EntityTurretProjectile(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.maxDist = 2.147483647E9;
    }

    public EntityTurretProjectile(World world, Entity shooter, Entity target) {
        this(world);
        double y = shooter.field_70163_u + (double)shooter.func_70047_e() - 0.1;
        this.func_70107_b(shooter.field_70165_t, y, shooter.field_70161_v);
        if (shooter instanceof EntityTurret) {
            EntityTurret turret = (EntityTurret)shooter;
            if (turret.isUpsideDown()) {
                y -= 1.0;
            }
            this.maxDist = turret.getTargetProcessor().getRangeVal() * 4.0;
        }
        this.shooterUUID = shooter.func_110124_au();
        this.shooterCache = shooter;
        this.targetUUID = target.func_110124_au();
        this.targetCache = target;
        Vec3d targetVec = new Vec3d(target.field_70165_t - shooter.field_70165_t, target.func_174813_aQ().field_72338_b + (double)target.field_70131_O / 1.4 - y, target.field_70161_v - shooter.field_70161_v);
        this.setHeadingFromVec(targetVec.func_72432_b());
        this.field_70181_x += (double)this.getArc() * Math.sqrt(targetVec.field_72450_a * targetVec.field_72450_a + targetVec.field_72449_c * targetVec.field_72449_c) * 0.05;
    }

    public EntityTurretProjectile(World world, Entity shooter, Vec3d shootingVec) {
        this(world, shooter, (Entity)null);
        this.setHeadingFromVec(shootingVec.func_72432_b());
    }

    private void setHeadingFromVec(Vec3d vector) {
        double scatterVal = this.getScatterValue();
        float initSpeed = this.getInitialSpeedMultiplier();
        this.field_70159_w = vector.field_72450_a * (double)initSpeed + (MiscUtils.RNG.randomDouble() * 2.0 - 1.0) * scatterVal;
        this.field_70179_y = vector.field_72449_c * (double)initSpeed + (MiscUtils.RNG.randomDouble() * 2.0 - 1.0) * scatterVal;
        this.field_70181_x = vector.field_72448_b * (double)initSpeed + (MiscUtils.RNG.randomDouble() * 2.0 - 1.0) * scatterVal;
        float vecPlaneNormal = MathHelper.func_76133_a((double)(vector.field_72450_a * vector.field_72450_a + vector.field_72449_c * vector.field_72449_c));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(vector.field_72450_a, vector.field_72449_c) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(vector.field_72448_b, vecPlaneNormal) * 180.0 / Math.PI);
    }

    protected void func_70088_a() {
        if (this.shooterUUID != null && this.shooterCache == null) {
            this.shooterCache = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.shooterUUID);
        }
        if (this.targetUUID != null && this.targetCache == null) {
            this.targetCache = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.targetUUID);
        }
    }

    public void func_70071_h_() {
        this.field_70160_al = true;
        if (this.shooterCache != null && (double)this.func_70032_d(this.shooterCache) > this.maxDist) {
            this.func_70106_y();
            return;
        }
        this.doCollisionCheck();
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float speed = this.getSpeedMultiplierAir();
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                float disPos = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)disPos, this.field_70163_u - this.field_70181_x * (double)disPos, this.field_70161_v - this.field_70179_y * (double)disPos, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            speed = this.getSpeedMultiplierLiquid();
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.field_70159_w *= (double)speed;
        this.field_70181_x *= (double)speed;
        this.field_70179_y *= (double)speed;
        this.field_70181_x -= (double)(this.getArc() * 0.1f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
    }

    private void doCollisionCheck() {
        Vec3d posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d futurePosVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult hitObj = this.field_70170_p.func_147447_a(posVec, futurePosVec, false, true, false);
        posVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        futurePosVec = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (hitObj != null) {
            futurePosVec = new Vec3d(hitObj.field_72307_f.field_72450_a, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        AxisAlignedBB checkBB = this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0);
        List list = this.field_70170_p.func_72839_b((Entity)this, checkBB);
        double minDist = 0.0;
        for (Entity collidedEntity : list) {
            AxisAlignedBB collisionAABB;
            RayTraceResult interceptObj;
            if (!collidedEntity.func_70067_L() || collidedEntity == this.shooterCache || (interceptObj = (collisionAABB = collidedEntity.func_174813_aQ().func_186662_g(0.3)).func_72327_a(posVec, futurePosVec)) == null) continue;
            double vecDistance = posVec.func_72438_d(interceptObj.field_72307_f);
            if (EntityTurret.class.isAssignableFrom(collidedEntity.getClass()) || !(vecDistance < minDist) && minDist != 0.0) continue;
            entity = collidedEntity;
            minDist = vecDistance;
        }
        if (entity != null) {
            hitObj = new RayTraceResult(entity);
        }
        if (hitObj != null && hitObj.field_72308_g != null && hitObj.field_72308_g instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)hitObj.field_72308_g;
            if (player.field_71075_bZ.field_75102_a) {
                hitObj = null;
            }
        }
        if (hitObj != null) {
            if (hitObj.field_72308_g != null) {
                MutableFloat dmg = new MutableFloat(this.getDamage());
                DamageSource damagesource = this.getProjDamageSource(hitObj.field_72308_g);
                if (this.func_70027_ad() && !(hitObj.field_72308_g instanceof EntityEnderman)) {
                    hitObj.field_72308_g.func_70015_d(5);
                }
                boolean preHitVelocityChanged = hitObj.field_72308_g.field_70133_I;
                boolean preHitAirBorne = hitObj.field_72308_g.field_70160_al;
                double preHitMotionX = hitObj.field_72308_g.field_70159_w;
                double preHitMotionY = hitObj.field_72308_g.field_70181_x;
                double preHitMotionZ = hitObj.field_72308_g.field_70179_y;
                if (this.onPreHit(hitObj.field_72308_g, damagesource, dmg) && hitObj.field_72308_g.func_70097_a(damagesource, dmg.floatValue())) {
                    hitObj.field_72308_g.field_70133_I = preHitVelocityChanged;
                    hitObj.field_72308_g.field_70160_al = preHitAirBorne;
                    hitObj.field_72308_g.field_70159_w = preHitMotionX;
                    hitObj.field_72308_g.field_70181_x = preHitMotionY;
                    hitObj.field_72308_g.field_70179_y = preHitMotionZ;
                    this.onPostHit(hitObj.field_72308_g, damagesource);
                    if (hitObj.field_72308_g instanceof EntityLivingBase) {
                        EntityLivingBase living = (EntityLivingBase)hitObj.field_72308_g;
                        if (!this.field_70170_p.field_72995_K) {
                            living.func_85034_r(living.func_85035_bI() + 1);
                        }
                        if (living instanceof EntityCreature && this.shooterCache instanceof EntityTurret) {
                            TmrUtils.INSTANCE.setEntityTarget((EntityCreature)living, (EntityTurret)this.shooterCache);
                        }
                        double deltaX = this.field_70165_t - living.field_70165_t;
                        double deltaZ = this.field_70161_v - living.field_70161_v;
                        while (deltaX * deltaX + deltaZ * deltaZ < 1.0E-4) {
                            deltaZ = (Math.random() - Math.random()) * 0.01;
                            deltaX = (Math.random() - Math.random()) * 0.01;
                        }
                        this.knockBackEntity(living, deltaX, deltaZ);
                        if (this.shooterCache instanceof EntityLivingBase) {
                            EnchantmentHelper.func_151384_a((EntityLivingBase)living, (Entity)this.shooterCache);
                            EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shooterCache), (Entity)living);
                        }
                    }
                }
            } else {
                this.onBlockHit(hitObj.func_178782_a());
            }
            this.processHit(hitObj);
        }
    }

    public DamageSource getProjDamageSource(Entity hitEntity) {
        return DamageSource.func_76356_a((Entity)this, (Entity)(this.shooterCache == null ? this : this.shooterCache));
    }

    public void knockBackEntity(EntityLivingBase living, double deltaX, double deltaZ) {
        if (this.field_70146_Z.nextDouble() >= living.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            living.field_70160_al = true;
            double normXZ = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
            double kbStrengthXZ = this.getKnockbackStrengthH();
            double kbStrengthY = this.getKnockbackStrengthV();
            living.field_70159_w /= 2.0;
            living.field_70181_x /= 2.0;
            living.field_70179_y /= 2.0;
            living.field_70159_w -= deltaX / normXZ * kbStrengthXZ;
            living.field_70181_x += kbStrengthY;
            living.field_70179_y -= deltaZ / normXZ * kbStrengthXZ;
            if (living.field_70181_x > (double)0.4f) {
                living.field_70181_x = 0.4f;
            }
        }
    }

    protected void processHit(RayTraceResult hitObj) {
        this.func_70107_b(hitObj.field_72307_f.field_72450_a, hitObj.field_72307_f.field_72448_b, hitObj.field_72307_f.field_72449_c);
        this.func_184185_a(this.getRicochetSound(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        this.func_70106_y();
    }

    private void onBlockHit(BlockPos pos) {
    }

    public abstract float getInitialSpeedMultiplier();

    public abstract float getDamage();

    public abstract float getKnockbackStrengthH();

    public abstract float getKnockbackStrengthV();

    public abstract SoundEvent getRicochetSound();

    public double getScatterValue() {
        return 0.0;
    }

    public float getSpeedMultiplierAir() {
        return 1.0f;
    }

    public float getSpeedMultiplierLiquid() {
        return 0.8f;
    }

    public boolean onPreHit(Entity e, DamageSource dmgSource, MutableFloat dmg) {
        return !(e instanceof EntityWither) || !((EntityWither)e).func_82205_o() || !dmgSource.func_76352_a();
    }

    public void onPostHit(Entity e, DamageSource dmgSource) {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("shooter")) {
            this.shooterUUID = UUID.fromString(nbt.func_74779_i("shooter"));
            this.shooterCache = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.shooterUUID);
        }
        if (nbt.func_74764_b("target")) {
            this.targetUUID = UUID.fromString(nbt.func_74779_i("target"));
            this.targetCache = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.targetUUID);
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.shooterUUID != null) {
            nbt.func_74778_a("shooter", this.shooterUUID.toString());
        }
        if (this.targetUUID != null) {
            nbt.func_74778_a("target", this.targetUUID.toString());
        }
    }

    public void func_70186_c(double x, double y, double z, float recoil, float randMulti) {
        float vecNormal = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)vecNormal;
        y /= (double)vecNormal;
        z /= (double)vecNormal;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randMulti;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randMulti;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)randMulti;
        this.field_70159_w = x *= (double)recoil;
        this.field_70181_x = y *= (double)recoil;
        this.field_70179_y = z *= (double)recoil;
        float vecPlaneNormal = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, vecPlaneNormal) * 180.0 / Math.PI);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.field_70177_z);
        buffer.writeFloat(this.field_70125_A);
        buffer.writeBoolean(this.shooterCache != null);
        if (this.shooterCache != null) {
            buffer.writeInt(this.shooterCache.func_145782_y());
        }
        buffer.writeBoolean(this.targetCache != null);
        if (this.targetCache != null) {
            buffer.writeInt(this.targetCache.func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.field_70177_z = buffer.readFloat();
        this.field_70125_A = buffer.readFloat();
        if (buffer.readBoolean()) {
            this.shooterCache = this.field_70170_p.func_73045_a(buffer.readInt());
        }
        if (buffer.readBoolean()) {
            this.targetCache = this.field_70170_p.func_73045_a(buffer.readInt());
        }
    }

    public abstract float getArc();
}

