/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import com.mojang.authlib.GameProfile;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.api.repairkit.TurretRepairKit;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.entity.turret.DataWatcherBooleans;
import de.sanandrew.mods.turretmod.entity.turret.TargetProcessor;
import de.sanandrew.mods.turretmod.entity.turret.UpgradeProcessor;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketUpdateTurretState;
import de.sanandrew.mods.turretmod.registry.repairkit.RepairKitRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.util.Sounds;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityTurret
extends EntityLiving
implements IEntityAdditionalSpawnData,
ITurretInst {
    private static final AxisAlignedBB UPWARDS_BLOCK = new AxisAlignedBB(0.1, 0.99, 0.1, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB DOWNWARDS_BLOCK = new AxisAlignedBB(0.1, 0.0, 0.1, 1.0, 0.01, 1.0);
    public static final DataParameter<Boolean> SHOT_CHNG = EntityDataManager.func_187226_a(EntityTurret.class, (DataSerializer)DataSerializers.field_187198_h);
    public boolean isUpsideDown;
    public boolean showRange;
    public boolean inGui;
    protected final TargetProcessor targetProc = new TargetProcessor(this);
    protected final UpgradeProcessor upgProc = new UpgradeProcessor(this);
    protected UUID ownerUUID;
    protected String ownerName;
    private DataWatcherBooleans<EntityTurret> dwBools;
    private BlockPos blockPos;
    private boolean prevShotChng;
    private final boolean checkBlock;
    private ITurretRAM turretRAM;
    private ITurret delegate;

    public EntityTurret(World world) {
        super(world);
        this.field_70177_z = 0.0f;
        this.checkBlock = true;
        this.delegate = TurretRegistry.NULL_TURRET;
    }

    public EntityTurret(World world, ITurret delegate) {
        this(world);
        this.delegate = delegate;
        this.delegate.entityInit(this);
        this.delegate.applyEntityAttributes(this);
        this.func_70606_j(this.func_110138_aP());
    }

    public EntityTurret(World world, boolean isUpsideDown, EntityPlayer owner, ITurret delegate) {
        this(world, delegate);
        this.isUpsideDown = isUpsideDown;
        this.ownerUUID = owner.func_110124_au();
        this.ownerName = owner.func_70005_c_();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_AMMO_CAPACITY);
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_RELOAD_TICKS);
        this.func_110140_aT().func_111150_b(TurretAttributes.MAX_INIT_SHOOT_TICKS);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.dwBools = new DataWatcherBooleans<EntityTurret>(this);
        this.dwBools.registerDwValue();
        this.field_70180_af.func_187214_a(SHOT_CHNG, (Object)false);
        this.setActive(true);
    }

    protected SoundEvent func_184601_bQ() {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getHurtSound(this), (Object)Sounds.HIT_TURRETHIT);
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getDeathSound(this), (Object)Sounds.HIT_TURRETDEATH);
    }

    protected SoundEvent getCollectSound() {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getCollectSound(this), (Object)Sounds.COLLECT_IA_GET);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70625_a(Entity entity, float yawSpeed, float pitchSpeed) {
        double deltaY;
        double deltaX = entity.field_70165_t - this.field_70165_t;
        double deltaZ = entity.field_70161_v - this.field_70161_v;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            deltaY = livingBase.field_70163_u + (double)livingBase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            deltaY = (entity.func_174813_aQ().field_72338_b + entity.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double distVecXZ = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        float yawRotation = (float)((this.isUpsideDown ? -1.0 : 1.0) * (Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI)) - 90.0f;
        float pitchRotation = (float)(-(Math.atan2(deltaY *= this.isUpsideDown ? -1.0 : 1.0, distVecXZ) * 180.0 / Math.PI));
        this.field_70125_A = this.updateRotation(this.field_70125_A, pitchRotation);
        this.field_70759_as = this.updateRotation(this.field_70759_as, yawRotation);
    }

    public void func_70034_d(float rotation) {
    }

    protected float updateRotation(float prevRotation, float newRotation) {
        float speed = 20.0f;
        float part = MathHelper.func_76142_g((float)(newRotation - prevRotation));
        if (part > 20.0f) {
            part = 20.0f;
        }
        if (part < -20.0f) {
            part = -20.0f;
        }
        return prevRotation + part;
    }

    public void func_70071_h_() {
        if (!this.inGui) {
            super.func_70071_h_();
            this.field_70177_z = 0.0f;
            this.field_70761_aq = 0.0f;
            this.delegate.onUpdate(this);
        }
    }

    @Override
    public boolean wasShooting() {
        boolean shot = (Boolean)this.field_70180_af.func_187225_a(SHOT_CHNG) != this.prevShotChng;
        this.prevShotChng = (Boolean)this.field_70180_af.func_187225_a(SHOT_CHNG);
        return shot;
    }

    @Override
    public void setShooting() {
        this.field_70180_af.func_187227_b(SHOT_CHNG, (Object)((Boolean)this.field_70180_af.func_187225_a(SHOT_CHNG) == false ? 1 : 0));
    }

    public void func_70636_d() {
        if (this.blockPos == null) {
            this.blockPos = this.func_180425_c().func_177981_b(this.isUpsideDown ? 2 : -1);
        }
        if (!this.isUpsideDown) {
            this.field_70181_x -= (double)0.0325f;
            super.func_70091_d(0.0, this.field_70181_x, 0.0);
            this.blockPos = this.func_180425_c().func_177979_c(1);
        } else if (this.checkBlock && !EntityTurret.canTurretBePlaced(this.field_70170_p, this.blockPos, true, this.isUpsideDown)) {
            this.func_174812_G();
        }
        this.field_70170_p.field_72984_F.func_76320_a("ai");
        if (this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_70701_bs = 0.0f;
            this.field_70704_bt = 0.0f;
        } else if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.field_72984_F.func_76320_a("oldAi");
            this.updateMyEntityActionState();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        this.upgProc.onTick();
        if (!this.field_70170_p.field_72995_K) {
            this.targetProc.onTick();
        }
        if (this.isActive()) {
            if (this.targetProc.hasTarget()) {
                this.func_70625_a(this.targetProc.getTarget(), 10.0f, this.func_70646_bf());
            } else if (this.field_70170_p.field_72995_K && TmrUtils.INSTANCE.getPassengersOfClass((Entity)this, EntityPlayer.class).size() < 1) {
                this.field_70759_as += 1.0f;
                this.field_70759_as = TmrUtils.wrap360(this.field_70759_as);
                this.field_70758_at = TmrUtils.wrap360(this.field_70758_at);
                if (this.field_70125_A < 0.0f) {
                    this.field_70125_A += 5.0f;
                    if (this.field_70125_A > 0.0f) {
                        this.field_70125_A = 0.0f;
                    }
                } else if (this.field_70125_A > 0.0f) {
                    this.field_70125_A -= 5.0f;
                    if (this.field_70125_A < 0.0f) {
                        this.field_70125_A = 0.0f;
                    }
                }
            }
        } else {
            float lockedPitch;
            this.field_70759_as = TmrUtils.wrap360(this.field_70759_as);
            this.field_70758_at = TmrUtils.wrap360(this.field_70758_at);
            float closestRot = (float)(MathHelper.func_76123_f((float)this.field_70759_as) / 90) * 90.0f;
            if (this.field_70759_as > closestRot) {
                this.field_70759_as -= 5.0f;
                if (this.field_70759_as < closestRot) {
                    this.field_70759_as = closestRot;
                }
            } else if (this.field_70759_as < closestRot) {
                this.field_70759_as += 5.0f;
                if (this.field_70759_as > closestRot) {
                    this.field_70759_as = closestRot;
                }
            }
            if (this.field_70125_A < (lockedPitch = this.delegate.getDeactiveHeadPitch())) {
                this.field_70125_A += 1.0f;
                if (this.field_70125_A > lockedPitch) {
                    this.field_70125_A = lockedPitch;
                }
            } else if (this.field_70125_A > lockedPitch) {
                this.field_70125_A -= 1.0f;
                if (this.field_70125_A < lockedPitch) {
                    this.field_70125_A = lockedPitch;
                }
            }
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    private void onInteractSucceed(ItemStack heldItem, EntityPlayer player) {
        if (heldItem.field_77994_a == 0) {
            player.field_71071_by.func_70304_b(player.field_71071_by.field_70461_c);
        } else {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldItem.func_77946_l());
        }
        this.updateState();
        player.field_71069_bz.func_75142_b();
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getCollectSound(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand, ItemStack stacks) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.field_70170_p.field_72995_K) {
            if (ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.TURRET_CONTROL_UNIT)) {
                TmrUtils.INSTANCE.openGui(player, player.func_70093_af() ? EnumGui.GUI_DEBUG_CAMERA : EnumGui.GUI_TCU, this.func_145782_y(), 0, 0);
                return true;
            }
            return false;
        }
        if (ItemStackUtils.isValid((ItemStack)stack) && hand == EnumHand.MAIN_HAND) {
            if (this.targetProc.addAmmo(stack)) {
                this.onInteractSucceed(stack, player);
                return true;
            }
            TurretRepairKit repKit = RepairKitRegistry.INSTANCE.getType(stack);
            if (repKit.isApplicable(this)) {
                this.func_70691_i(repKit.getHealAmount());
                repKit.onHeal(this);
                --stack.field_77994_a;
                this.onInteractSucceed(stack, player);
                return true;
            }
            if (this.upgProc.tryApplyUpgrade(stack.func_77946_l())) {
                --stack.field_77994_a;
                this.onInteractSucceed(stack, player);
                return true;
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    public void func_70645_a(DamageSource dmgSrc) {
        super.func_70645_a(dmgSrc);
        if (!this.field_70170_p.field_72995_K) {
            this.targetProc.dropAmmo();
            this.upgProc.dropUpgrades();
        }
        this.func_70106_y();
    }

    protected void updateMyEntityActionState() {
        ++this.field_70708_bq;
        this.field_70702_br = 0.0f;
        this.field_70701_bs = 0.0f;
        this.field_70177_z = 0.0f;
    }

    @Override
    public ITargetProcessor getTargetProcessor() {
        return this.targetProc;
    }

    @Override
    public IUpgradeProcessor getUpgradeProcessor() {
        return this.upgProc;
    }

    public void writeSpawnData(ByteBuf buffer) {
        UUID turretId = this.delegate.getId();
        buffer.writeLong(turretId.getMostSignificantBits());
        buffer.writeLong(turretId.getLeastSignificantBits());
        NBTTagCompound targetNbt = new NBTTagCompound();
        this.targetProc.writeToNbt(targetNbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)targetNbt);
        NBTTagCompound upgNbt = new NBTTagCompound();
        this.upgProc.writeToNbt(upgNbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)upgNbt);
        buffer.writeBoolean(this.isUpsideDown);
        if (this.ownerUUID != null) {
            buffer.writeBoolean(true);
            buffer.writeLong(this.ownerUUID.getMostSignificantBits());
            buffer.writeLong(this.ownerUUID.getLeastSignificantBits());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.ownerName);
        } else {
            buffer.writeBoolean(false);
        }
        this.delegate.writeSpawnData(this, buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.delegate = TurretRegistry.INSTANCE.getTurret(new UUID(buffer.readLong(), buffer.readLong()));
        this.targetProc.readFromNbt(ByteBufUtils.readTag((ByteBuf)buffer));
        this.upgProc.readFromNbt(ByteBufUtils.readTag((ByteBuf)buffer));
        this.isUpsideDown = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.ownerUUID = new UUID(buffer.readLong(), buffer.readLong());
            this.ownerName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        this.delegate.readSpawnData(this, buffer);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74778_a("turretId", this.delegate.getId().toString());
        this.targetProc.writeToNbt(nbt);
        this.upgProc.writeToNbt(nbt);
        this.dwBools.writeToNbt(nbt);
        nbt.func_74757_a("isUpsideDown", this.isUpsideDown);
        if (this.ownerUUID != null) {
            nbt.func_74778_a("ownerUUID", this.ownerUUID.toString());
            nbt.func_74778_a("ownerName", this.ownerName);
        }
        this.delegate.onSave(this, nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        String turretId = nbt.func_74779_i("turretId");
        if (UuidUtils.isStringUuid((String)turretId)) {
            this.delegate = TurretRegistry.INSTANCE.getTurret(UUID.fromString(turretId));
            this.delegate.entityInit(this);
            this.delegate.applyEntityAttributes(this);
        }
        this.targetProc.readFromNbt(nbt);
        this.upgProc.readFromNbt(nbt);
        this.dwBools.readFromNbt(nbt);
        this.isUpsideDown = nbt.func_74767_n("isUpsideDown");
        if (nbt.func_74764_b("ownerUUID")) {
            this.ownerUUID = UUID.fromString(nbt.func_74779_i("ownerUUID"));
            this.ownerName = nbt.func_74779_i("ownerName");
        }
        this.delegate.onLoad(this, nbt);
    }

    public int func_70646_bf() {
        return 50;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_82720_e();
    }

    public final void func_70653_a(Entity entity, float unknown, double motionXAmount, double motionZAmount) {
    }

    public final void func_70091_d(double motionX, double motionY, double motionZ) {
        super.func_70091_d(0.0, motionY, 0.0);
    }

    public final void func_70612_e(float strafe, float vertical) {
    }

    public ResourceLocation getStandardTexture() {
        return this.delegate.getStandardTexture(this);
    }

    public ResourceLocation getGlowTexture() {
        return this.delegate.getGlowTexture(this);
    }

    @Override
    public SoundEvent getShootSound() {
        return this.delegate.getShootSound(this);
    }

    @Override
    public SoundEvent getNoAmmoSound() {
        return (SoundEvent)MiscUtils.defIfNull((Object)this.delegate.getNoAmmoSound(this), (Object)SoundEvents.field_187576_at);
    }

    @Override
    public boolean isActive() {
        return this.dwBools.getBit(DataWatcherBooleans.Turret.ACTIVE.bit);
    }

    @Override
    public void setActive(boolean isActive) {
        this.dwBools.setBit(DataWatcherBooleans.Turret.ACTIVE.bit, isActive);
    }

    @Override
    public boolean showRange() {
        return this.showRange;
    }

    @Override
    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
    }

    private static boolean isAABBInside(AxisAlignedBB bb1, AxisAlignedBB bb2) {
        return bb1.field_72340_a <= bb2.field_72340_a && bb1.field_72338_b <= bb2.field_72338_b && bb1.field_72339_c <= bb2.field_72339_c && bb1.field_72336_d >= bb2.field_72336_d && bb1.field_72337_e >= bb2.field_72337_e && bb1.field_72334_f >= bb2.field_72334_f;
    }

    public static boolean canTurretBePlaced(World world, BlockPos pos, boolean doBlockCheckOnly, boolean updideDown) {
        AxisAlignedBB aabb;
        AxisAlignedBB blockBB = world.func_180495_p(pos).func_185890_d(world, pos);
        if (blockBB == null || !EntityTurret.isAABBInside(blockBB, updideDown ? DOWNWARDS_BLOCK : UPWARDS_BLOCK)) {
            return false;
        }
        BlockPos posPlaced = pos.func_177972_a(updideDown ? EnumFacing.DOWN : EnumFacing.UP);
        BlockPos posPlaced2 = pos.func_177967_a(updideDown ? EnumFacing.DOWN : EnumFacing.UP, 2);
        if (!world.func_180495_p(posPlaced).func_177230_c().func_176200_f((IBlockAccess)world, posPlaced) || !world.func_180495_p(posPlaced2).func_177230_c().func_176200_f((IBlockAccess)world, posPlaced2)) {
            return false;
        }
        return doBlockCheckOnly || world.func_72872_a(EntityTurret.class, aabb = new AxisAlignedBB((double)posPlaced.func_177958_n(), (double)posPlaced.func_177956_o(), (double)posPlaced.func_177952_p(), (double)posPlaced.func_177958_n() + 1.0, (double)posPlaced.func_177956_o() + (updideDown ? -1.0 : 1.0), (double)posPlaced.func_177952_p() + 1.0)).isEmpty();
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public boolean hasPlayerPermission(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (this.ownerUUID == null) {
            return true;
        }
        MinecraftServer mcSrv = this.field_70170_p.func_73046_m();
        GameProfile profile = player.func_146103_bH();
        if (mcSrv != null && mcSrv.func_71264_H() && mcSrv.func_71214_G().equals(profile.getName())) {
            return true;
        }
        if (TmrUtils.INSTANCE.canPlayerEditAll() || this.ownerUUID.equals(profile.getId())) {
            return true;
        }
        return player.func_70003_b(2, "") && TmrUtils.INSTANCE.canOpEditAll();
    }

    @Override
    public boolean isInGui() {
        return this.inGui;
    }

    @Override
    public <V extends ITurretRAM> V getRAM(Supplier<V> onNull) {
        if (this.turretRAM == null && onNull != null) {
            this.turretRAM = (ITurretRAM)onNull.get();
        }
        return (V)((ITurretRAM)ReflectionUtils.getCasted((Object)this.turretRAM));
    }

    @Override
    public void updateState() {
        PacketRegistry.sendToAllAround((IMessage)new PacketUpdateTurretState(this), this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return TurretRegistry.INSTANCE.getTurretItem(this.delegate);
    }

    public void func_174812_G() {
        this.func_70097_a(DamageSource.field_76376_m, Float.MAX_VALUE);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity instanceof EntityPlayer ? entity.func_174813_aQ() : null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    @Override
    public AxisAlignedBB getRangeBB() {
        return this.delegate.getRangeBB(this);
    }

    @Override
    public boolean isUpsideDown() {
        return this.isUpsideDown;
    }

    @Override
    public EntityLiving getEntity() {
        return this;
    }

    @Override
    public ITurret getTurret() {
        return this.delegate;
    }
}

