/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import com.google.common.collect.Maps;
import de.sanandrew.mods.sanlib.lib.util.EntityUtils;
import de.sanandrew.mods.sanlib.lib.util.InventoryUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.event.TargetingEvent;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class TargetProcessor
implements ITargetProcessor {
    protected static final Map<Class<? extends Entity>, Boolean> ENTITY_TARGET_LIST_STD = new HashMap<Class<? extends Entity>, Boolean>();
    protected final Map<Class<? extends Entity>, Boolean> entityTargetList = new HashMap<Class<? extends Entity>, Boolean>(ENTITY_TARGET_LIST_STD);
    protected final Map<UUID, Boolean> playerTargetList = new HashMap<UUID, Boolean>();
    protected final ITurretInst turret;
    protected int ammoCount;
    protected ItemStack ammoStack;
    protected int shootTicks;
    protected int initShootTicks;
    protected Entity entityToAttack;
    protected UUID entityToAttackUUID;
    protected boolean isShootingClt;
    protected boolean isBlacklistEntity = false;
    protected boolean isBlacklistPlayer = false;
    protected long processTicks = 0L;

    public TargetProcessor(ITurretInst turret) {
        this.turret = turret;
        this.initShootTicks = 20;
        this.ammoStack = ItemStackUtils.getEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean addAmmo(ItemStack stack) {
        int maxCapacity;
        UUID currType;
        if (!this.isAmmoApplicable(stack)) return false;
        IAmmunition type = AmmunitionRegistry.INSTANCE.getType(stack);
        UUID uUID = currType = ItemStackUtils.isValid((ItemStack)this.ammoStack) ? AmmunitionRegistry.INSTANCE.getType(this.ammoStack).getTypeId() : null;
        if (currType != null && !currType.equals(type.getTypeId())) {
            this.dropAmmo();
        }
        if ((maxCapacity = this.getMaxAmmoCapacity() - this.ammoCount) <= 0) return false;
        if (!this.hasAmmo()) {
            this.ammoStack = type.getStoringAmmoItem();
        } else if (!AmmunitionRegistry.INSTANCE.areAmmoItemsEqual(stack, this.ammoStack)) {
            return false;
        }
        int provided = type.getAmmoCapacity();
        int providedStack = stack.field_77994_a * provided;
        if (providedStack - maxCapacity > 0) {
            int stackSub = MathHelper.func_76128_c((double)((double)maxCapacity / (double)providedStack * (double)stack.field_77994_a));
            if (stackSub <= 0) return false;
            this.ammoCount += stackSub * provided;
            stack.field_77994_a -= stackSub;
            return true;
        } else {
            this.ammoCount += providedStack;
            stack.field_77994_a = 0;
        }
        return true;
    }

    @Override
    public int getAmmoCount() {
        return this.ammoCount;
    }

    @Override
    public ItemStack getAmmoStack() {
        if (ItemStackUtils.isValid((ItemStack)this.ammoStack)) {
            return this.ammoStack.func_77946_l();
        }
        return ItemStackUtils.getEmpty();
    }

    @Override
    public boolean hasAmmo() {
        return ItemStackUtils.isValid((ItemStack)this.ammoStack) && this.ammoCount > 0;
    }

    @Override
    public void dropExcessAmmo() {
        int decrAmmo;
        if (this.hasAmmo() && (decrAmmo = this.ammoCount - this.getMaxAmmoCapacity()) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            IAmmunition type = AmmunitionRegistry.INSTANCE.getType(this.ammoStack);
            int maxStackSize = this.ammoStack.func_77976_d();
            while (decrAmmo > 0 && type != AmmunitionRegistry.NULL_TYPE) {
                ItemStack stack = this.ammoStack.func_77946_l();
                stack.field_77994_a = Math.min(decrAmmo / type.getAmmoCapacity(), maxStackSize);
                decrAmmo -= stack.field_77994_a * type.getAmmoCapacity();
                if (stack.field_77994_a <= 0) break;
                items.add(stack);
            }
            this.ammoCount = this.getMaxAmmoCapacity();
            if (!items.isEmpty()) {
                EntityLiving turretL = this.turret.getEntity();
                for (ItemStack stack : items) {
                    EntityItem item = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, stack);
                    turretL.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    @Override
    public void decrAmmo() {
        TargetingEvent.ConsumeAmmo event = new TargetingEvent.ConsumeAmmo(this, this.ammoStack, 1);
        if (!TARGET_BUS.post((Event)event) && event.getResult() != Event.Result.DENY) {
            this.ammoCount -= event.consumeAmount;
            if (this.ammoCount < 0) {
                this.ammoCount = 0;
            }
        }
    }

    public void dropAmmo() {
        if (this.hasAmmo()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int maxStackSize = this.ammoStack.func_77976_d();
            IAmmunition type = AmmunitionRegistry.INSTANCE.getType(this.ammoStack);
            while (this.ammoCount > 0 && type != AmmunitionRegistry.NULL_TYPE) {
                ItemStack stack = this.ammoStack.func_77946_l();
                stack.field_77994_a = Math.min(this.ammoCount / type.getAmmoCapacity(), maxStackSize);
                this.ammoCount -= stack.field_77994_a * type.getAmmoCapacity();
                if (stack.field_77994_a <= 0) {
                    this.ammoCount = 0;
                    break;
                }
                items.add(stack);
            }
            this.ammoStack = ItemStackUtils.getEmpty();
            if (!items.isEmpty()) {
                EntityLiving turretL = this.turret.getEntity();
                for (ItemStack stack : items) {
                    EntityItem item = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, stack);
                    turretL.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    public void putAmmoInInventory(IInventory inventory) {
        if (this.hasAmmo()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            int maxStackSize = this.ammoStack.func_77976_d();
            IAmmunition type = AmmunitionRegistry.INSTANCE.getType(this.ammoStack);
            while (this.ammoCount > 0 && type != AmmunitionRegistry.NULL_TYPE) {
                ItemStack stack = this.ammoStack.func_77946_l();
                stack.field_77994_a = Math.min(this.ammoCount / type.getAmmoCapacity(), maxStackSize);
                this.ammoCount -= stack.field_77994_a * type.getAmmoCapacity();
                if (stack.field_77994_a <= 0) {
                    this.ammoCount = 0;
                    break;
                }
                items.add(stack);
            }
            this.ammoStack = ItemStackUtils.getEmpty();
            if (!items.isEmpty()) {
                EntityLiving turretL = this.turret.getEntity();
                for (ItemStack stack : items) {
                    if (!ItemStackUtils.isValid((ItemStack)(stack = InventoryUtils.addStackToInventory((ItemStack)stack, (IInventory)inventory)))) continue;
                    EntityItem item = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, stack);
                    turretL.field_70170_p.func_72838_d((Entity)item);
                }
            }
        }
    }

    @Override
    public boolean isAmmoApplicable(ItemStack stack) {
        IAmmunition stackType;
        if (ItemStackUtils.isValid((ItemStack)stack) && (stackType = AmmunitionRegistry.INSTANCE.getType(stack)) != AmmunitionRegistry.NULL_TYPE) {
            if (AmmunitionRegistry.INSTANCE.getType(this.ammoStack).getTypeId().equals(stackType.getTypeId())) {
                return this.ammoCount < this.getMaxAmmoCapacity();
            }
            List<IAmmunition> types = AmmunitionRegistry.INSTANCE.getTypesForTurret(this.turret.getTurret());
            if (types.contains(stackType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final int getMaxAmmoCapacity() {
        return MathHelper.func_76143_f((double)this.turret.getEntity().func_110148_a(TurretAttributes.MAX_AMMO_CAPACITY).func_111126_e());
    }

    @Override
    public final int getMaxShootTicks() {
        return MathHelper.func_76143_f((double)this.turret.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111126_e());
    }

    @Override
    public final boolean isShooting() {
        return this.initShootTicks <= 0 || this.isShootingClt;
    }

    @Override
    public boolean canShoot() {
        return this.initShootTicks <= 0 && this.shootTicks == 0;
    }

    @Override
    public void setShot(boolean success) {
        this.shootTicks = success ? this.getMaxShootTicks() : this.getMaxInitShootTicks();
    }

    @Override
    public void decrInitShootTicks() {
        --this.initShootTicks;
    }

    @Override
    public void resetInitShootTicks() {
        this.initShootTicks = this.getMaxInitShootTicks();
    }

    private int getMaxInitShootTicks() {
        return (int)Math.round(this.turret.getEntity().func_110148_a(TurretAttributes.MAX_INIT_SHOOT_TICKS).func_111126_e());
    }

    @Override
    public Entity getProjectile() {
        IAmmunition ammo = AmmunitionRegistry.INSTANCE.getType(this.ammoStack);
        if (ammo != AmmunitionRegistry.NULL_TYPE) {
            return ammo.getEntity(this.turret);
        }
        return null;
    }

    @Override
    public double getRangeVal() {
        AxisAlignedBB aabb = this.getAdjustedRange(false);
        return Math.max(aabb.field_72336_d - aabb.field_72340_a, Math.max(aabb.field_72337_e - aabb.field_72338_b, aabb.field_72334_f - aabb.field_72339_c)) / 2.0;
    }

    @Override
    public AxisAlignedBB getAdjustedRange(boolean doOffset) {
        AxisAlignedBB aabb = this.turret.getRangeBB();
        if (this.turret.isUpsideDown()) {
            aabb = new AxisAlignedBB(aabb.field_72340_a, -aabb.field_72337_e, aabb.field_72339_c, aabb.field_72336_d, -aabb.field_72338_b, aabb.field_72334_f);
        }
        EntityLiving turretL = this.turret.getEntity();
        return doOffset ? aabb.func_72317_d(turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v) : aabb;
    }

    private boolean checkTargetListeners(Entity e) {
        TargetingEvent.TargetCheck event = new TargetingEvent.TargetCheck(this, e);
        return !TARGET_BUS.post((Event)event) && event.getResult() != Event.Result.DENY;
    }

    @Override
    public boolean shootProjectile() {
        TargetingEvent.Shooting event = new TargetingEvent.Shooting(this);
        if (TARGET_BUS.post((Event)event)) {
            return event.getResult() != Event.Result.DENY;
        }
        if (this.hasAmmo()) {
            Entity projectile = this.getProjectile();
            assert (projectile != null);
            this.turret.getEntity().field_70170_p.func_72838_d(projectile);
            this.playSound(this.turret.getShootSound(), 1.8f);
            this.turret.setShooting();
            this.decrAmmo();
            return event.getResult() != Event.Result.DENY;
        }
        this.playSound(this.turret.getNoAmmoSound(), 1.0f);
        return event.getResult() == Event.Result.ALLOW;
    }

    @Override
    public void playSound(SoundEvent sound, float volume) {
        EntityLiving turretL = this.turret.getEntity();
        float pitch = 1.0f / (turretL.func_70681_au().nextFloat() * 0.4f + 1.2f) + 0.5f;
        turretL.field_70170_p.func_184148_a(null, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, sound, SoundCategory.NEUTRAL, volume, pitch);
    }

    @Override
    public void onTick() {
        boolean changed = false;
        EntityLiving turretL = this.turret.getEntity();
        if (!this.turret.isActive()) {
            if (this.entityToAttack != null || this.entityToAttackUUID != null) {
                this.resetInitShootTicks();
                this.entityToAttack = null;
                this.entityToAttackUUID = null;
                this.turret.updateState();
            }
            return;
        }
        if (this.shootTicks > 0) {
            --this.shootTicks;
        }
        if (this.entityToAttack == null && this.entityToAttackUUID != null) {
            this.entityToAttack = EntityUtils.getEntityByUUID((World)turretL.field_70170_p, (UUID)this.entityToAttackUUID);
        }
        AxisAlignedBB aabb = this.getAdjustedRange(true);
        if (this.processTicks++ % 10L == 0L) {
            if (TARGET_BUS.post((Event)new TargetingEvent.ProcessorTick(this))) {
                return;
            }
            if (this.entityToAttack == null) {
                for (Entity entityObj : this.getValidTargetList(aabb)) {
                    EntityLivingBase livingBase = (EntityLivingBase)entityObj;
                    if (!this.checkTargetListeners((Entity)livingBase)) continue;
                    this.entityToAttack = livingBase;
                    this.entityToAttackUUID = livingBase.func_110124_au();
                    changed = true;
                    break;
                }
            }
        }
        if (this.entityToAttack != null) {
            if (this.isEntityValidTarget(this.entityToAttack, aabb) && this.checkTargetListeners(this.entityToAttack)) {
                if (this.canShoot()) {
                    this.setShot(this.shootProjectile());
                    changed = true;
                } else if (this.initShootTicks > 0) {
                    this.decrInitShootTicks();
                }
            } else {
                this.resetInitShootTicks();
                this.entityToAttack = null;
                this.entityToAttackUUID = null;
                changed = true;
            }
        }
        if (changed) {
            this.turret.updateState();
        }
    }

    @Override
    public boolean isEntityBlacklist() {
        return this.isBlacklistEntity;
    }

    @Override
    public boolean isPlayerBlacklist() {
        return this.isBlacklistPlayer;
    }

    @Override
    public void setEntityBlacklist(boolean isBlacklist) {
        this.isBlacklistEntity = isBlacklist;
    }

    @Override
    public void setPlayerBlacklist(boolean isBlacklist) {
        this.isBlacklistPlayer = isBlacklist;
    }

    @Override
    public boolean isEntityValidTarget(Entity entity) {
        return this.isEntityValidTarget(entity, this.getAdjustedRange(true));
    }

    @Override
    public List<Entity> getValidTargetList() {
        return this.getValidTargetList(this.getAdjustedRange(true));
    }

    @Override
    public boolean isEntityTargeted(Entity entity) {
        Boolean creatureSetting = this.entityTargetList.get(entity.getClass());
        if (creatureSetting != null) {
            return this.isBlacklistEntity ^ creatureSetting;
        }
        if (entity instanceof EntityPlayer) {
            boolean b = Boolean.TRUE.equals(this.playerTargetList.get(entity.func_110124_au())) || Boolean.TRUE.equals(this.playerTargetList.get(UuidUtils.EMPTY_UUID));
            return this.isBlacklistPlayer ^ b;
        }
        return false;
    }

    private List<Entity> getValidTargetList(AxisAlignedBB aabb) {
        return this.turret.getEntity().field_70170_p.func_175674_a((Entity)this.turret.getEntity(), aabb, entity -> this.isEntityValidTarget((Entity)entity, aabb));
    }

    private boolean isEntityValidTarget(Entity entity, AxisAlignedBB aabb) {
        return entity instanceof EntityLivingBase && this.isEntityTargeted(entity) && entity.func_70089_S() && entity.func_174813_aQ().func_72326_a(aabb) && (this.turret.getTurret().canSeeThroughBlocks() || this.turret.getEntity().func_70685_l(entity));
    }

    public static void initialize() {
        EntityList.func_180124_b().stream().map(EntityList.field_75625_b::get).filter(cls -> cls != null && EntityLiving.class.isAssignableFrom((Class<?>)cls) && !ITurretInst.class.isAssignableFrom((Class<?>)cls) && !EntityLiving.class.equals(cls)).forEach(cls -> ENTITY_TARGET_LIST_STD.put((Class<? extends Entity>)cls, IMob.class.isAssignableFrom((Class<?>)cls)));
    }

    @Override
    public ITurretInst getTurret() {
        return this.turret;
    }

    @Override
    public boolean hasTarget() {
        return this.entityToAttack != null;
    }

    @Override
    public Entity getTarget() {
        return this.entityToAttack;
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74768_a("ammoCount", this.ammoCount);
        if (ItemStackUtils.isValid((ItemStack)this.ammoStack)) {
            NBTTagCompound stackTag = new NBTTagCompound();
            this.ammoStack.func_77955_b(stackTag);
            nbt.func_74782_a("ammoStack", (NBTBase)stackTag);
        }
        if (this.entityToAttackUUID != null) {
            nbt.func_74778_a("targetUUID", this.entityToAttackUUID.toString());
        }
        nbt.func_74757_a("entityBlacklist", this.isBlacklistEntity);
        nbt.func_74757_a("playerBlacklist", this.isBlacklistPlayer);
        NBTTagList entityTargets = new NBTTagList();
        for (Class<? extends Entity> cls : this.getEnabledEntityTargets()) {
            entityTargets.func_74742_a((NBTBase)new NBTTagString(cls.getName()));
        }
        nbt.func_74782_a("entityTargets", (NBTBase)entityTargets);
        NBTTagList playerTargets = new NBTTagList();
        for (UUID uuid : this.getEnabledPlayerTargets()) {
            playerTargets.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        nbt.func_74782_a("playerTargets", (NBTBase)playerTargets);
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        this.ammoCount = nbt.func_74762_e("ammoCount");
        if (nbt.func_74764_b("ammoStack")) {
            this.ammoStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ammoStack"));
        }
        if (nbt.func_74764_b("targetUUID")) {
            this.entityToAttackUUID = UUID.fromString(nbt.func_74779_i("targetUUID"));
        }
        this.isBlacklistEntity = nbt.func_74767_n("entityBlacklist");
        this.isBlacklistPlayer = nbt.func_74767_n("playerBlacklist");
        ArrayList<Class<? extends Entity>> entityTgt = new ArrayList<Class<? extends Entity>>();
        NBTTagList list = nbt.func_150295_c("entityTargets", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            Class cls = ReflectionUtils.getClass((String)list.func_150307_f(i));
            if (cls == null) continue;
            entityTgt.add(cls);
        }
        this.updateEntityTargets(entityTgt);
        ArrayList<UUID> playerTgt = new ArrayList<UUID>();
        list = nbt.func_150295_c("playerTargets", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            try {
                UUID id = UUID.fromString(list.func_150307_f(i));
                if (id.equals(UuidUtils.EMPTY_UUID)) {
                    this.isBlacklistPlayer = true;
                    continue;
                }
                playerTgt.add(id);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.updatePlayerTargets(playerTgt.toArray(new UUID[playerTgt.size()]));
    }

    @Override
    public List<Class<? extends Entity>> getEnabledEntityTargets() {
        Set enabledClasses = Maps.filterEntries(this.entityTargetList, input -> input != null && (Boolean)input.getValue() != false).keySet();
        return new ArrayList<Class<? extends Entity>>(enabledClasses);
    }

    @Override
    public UUID[] getEnabledPlayerTargets() {
        Set enabledUUIDs = Maps.filterEntries(this.playerTargetList, input -> input != null && (Boolean)input.getValue() != false).keySet();
        return enabledUUIDs.toArray(new UUID[enabledUUIDs.size()]);
    }

    @Override
    public Map<Class<? extends Entity>, Boolean> getEntityTargets() {
        return new HashMap<Class<? extends Entity>, Boolean>(this.entityTargetList);
    }

    @Override
    public Map<UUID, Boolean> getPlayerTargets() {
        return new HashMap<UUID, Boolean>(this.playerTargetList);
    }

    @Override
    public void updateEntityTarget(Class<? extends Entity> cls, boolean active) {
        if (ENTITY_TARGET_LIST_STD.containsKey(cls)) {
            this.entityTargetList.put(cls, active);
        }
    }

    @Override
    public void updatePlayerTarget(UUID uid, boolean active) {
        this.playerTargetList.put(uid, active);
    }

    @Override
    public void updateEntityTargets(List<Class<? extends Entity>> classes) {
        this.entityTargetList.entrySet().forEach(entry -> entry.setValue(false));
        classes.stream().filter(cls -> cls != null && ENTITY_TARGET_LIST_STD.containsKey(cls)).forEach(cls -> this.entityTargetList.put((Class<? extends Entity>)cls, true));
    }

    @Override
    public void updatePlayerTargets(UUID[] uuids) {
        this.playerTargetList.entrySet().forEach(entry -> entry.setValue(false));
        for (UUID uuid : uuids) {
            if (uuid == null) continue;
            this.playerTargetList.put(uuid, true);
        }
    }

    public void updateClientState(int targetId, int ammoCount, ItemStack ammoStack, boolean isShooting) {
        EntityLiving turretL = this.turret.getEntity();
        if (turretL.field_70170_p.field_72995_K) {
            this.entityToAttack = targetId < 0 ? null : turretL.field_70170_p.func_73045_a(targetId);
            this.ammoCount = ammoCount;
            this.ammoStack = ammoStack;
            this.isShootingClt = isShooting;
        }
    }

    @Override
    public String getTargetName() {
        return this.hasTarget() ? EntityList.func_75621_b((Entity)this.entityToAttack) : "";
    }
}

