/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.entity.turret;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.ReflectionUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.api.upgrade.IUpgradeInstance;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketSyncUpgradeInst;
import de.sanandrew.mods.turretmod.network.PacketUpdateUgradeSlot;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class UpgradeProcessor
implements IUpgradeProcessor {
    private final List<ItemStack> upgradeStacks = new ArrayList<Object>(Collections.nCopies(36, null));
    private final Map<UUID, IUpgradeInstance> upgInstances = new ConcurrentHashMap<UUID, IUpgradeInstance>();
    private final Map<UUID, IUpgradeInstance> upgTickable = new ConcurrentHashMap<UUID, IUpgradeInstance>();
    private boolean hasChanged = false;
    private final ITurretInst turret;

    public UpgradeProcessor(ITurretInst turret) {
        this.turret = turret;
    }

    @Override
    public void onTick() {
        this.upgTickable.forEach((key, val) -> val.onTick(this.turret));
        if (this.hasChanged) {
            ITurretUpgrade upg;
            EntityItem itm;
            ITurretUpgrade upg2;
            ItemStack invStack;
            int i;
            EntityLiving turretL = this.turret.getEntity();
            int max = this.upgradeStacks.size();
            for (i = 0; i < max; ++i) {
                ITurretUpgrade dep;
                invStack = this.upgradeStacks.get(i);
                if (!ItemStackUtils.isValid((ItemStack)invStack) || (dep = (upg2 = UpgradeRegistry.INSTANCE.getUpgrade(invStack)).getDependantOn()) == null || this.hasUpgrade(dep)) continue;
                if (!turretL.field_70170_p.field_72995_K) {
                    EntityItem itm2 = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, invStack);
                    turretL.field_70170_p.func_72838_d((Entity)itm2);
                }
                upg2.onRemove(this.turret);
                this.upgradeStacks.set(i, ItemStackUtils.getEmpty());
            }
            if (!this.hasUpgrade(Upgrades.UPG_STORAGE_III)) {
                max = this.upgradeStacks.size();
                for (i = 27; i < max; ++i) {
                    invStack = this.upgradeStacks.get(i);
                    if (!ItemStackUtils.isValid((ItemStack)invStack)) continue;
                    if (!turretL.field_70170_p.field_72995_K) {
                        EntityItem itm3 = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, invStack);
                        turretL.field_70170_p.func_72838_d((Entity)itm3);
                    }
                    upg2 = UpgradeRegistry.INSTANCE.getUpgrade(invStack);
                    upg2.onRemove(this.turret);
                    this.upgradeStacks.set(i, ItemStackUtils.getEmpty());
                }
            }
            if (!this.hasUpgrade(Upgrades.UPG_STORAGE_II)) {
                for (i = 18; i < 27; ++i) {
                    ItemStack invStack2 = this.upgradeStacks.get(i);
                    if (!ItemStackUtils.isValid((ItemStack)invStack2)) continue;
                    if (!turretL.field_70170_p.field_72995_K) {
                        itm = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, invStack2);
                        turretL.field_70170_p.func_72838_d((Entity)itm);
                    }
                    upg = UpgradeRegistry.INSTANCE.getUpgrade(invStack2);
                    upg.onRemove(this.turret);
                    this.upgradeStacks.set(i, ItemStackUtils.getEmpty());
                }
            }
            if (!this.hasUpgrade(Upgrades.UPG_STORAGE_I)) {
                for (i = 9; i < 18; ++i) {
                    ItemStack invStack3 = this.upgradeStacks.get(i);
                    if (!ItemStackUtils.isValid((ItemStack)invStack3)) continue;
                    if (!turretL.field_70170_p.field_72995_K) {
                        itm = new EntityItem(turretL.field_70170_p, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, invStack3);
                        turretL.field_70170_p.func_72838_d((Entity)itm);
                    }
                    upg = UpgradeRegistry.INSTANCE.getUpgrade(invStack3);
                    upg.onRemove(this.turret);
                    this.upgradeStacks.set(i, ItemStackUtils.getEmpty());
                }
            }
        }
    }

    @Override
    public boolean hasUpgrade(UUID id) {
        ItemStack upgItemStack = UpgradeRegistry.INSTANCE.getUpgradeItem(id);
        return ItemStackUtils.isStackInList((ItemStack)upgItemStack, this.upgradeStacks);
    }

    @Override
    public boolean hasUpgrade(ITurretUpgrade upg) {
        ItemStack upgItemStack = UpgradeRegistry.INSTANCE.getUpgradeItem(upg);
        return ItemStackUtils.isStackInList((ItemStack)upgItemStack, this.upgradeStacks);
    }

    @Override
    public <T extends IUpgradeInstance> T getUpgradeInstance(UUID id) {
        return (T)((IUpgradeInstance)ReflectionUtils.getCasted((Object)this.upgInstances.get(id)));
    }

    @Override
    public void setUpgradeInstance(UUID id, IUpgradeInstance inst) {
        this.upgInstances.put(id, inst);
        if (inst.getClass().getAnnotation(IUpgradeInstance.UpgInstTickable.class) != null) {
            this.upgTickable.put(id, inst);
        }
    }

    @Override
    public void delUpgradeInstance(UUID id) {
        this.upgInstances.remove(id);
        this.upgTickable.remove(id);
    }

    public int func_70302_i_() {
        return this.upgradeStacks.size();
    }

    public boolean isEmpty() {
        return this.upgradeStacks.stream().noneMatch(ItemStackUtils::isValid);
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.upgradeStacks.size() ? this.upgradeStacks.get(slot) : ItemStackUtils.getEmpty();
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack slotStack = this.upgradeStacks.get(slot);
        if (ItemStackUtils.isValid((ItemStack)slotStack)) {
            if (slotStack.field_77994_a <= amount) {
                ITurretUpgrade upg = UpgradeRegistry.INSTANCE.getUpgrade(slotStack);
                upg.onRemove(this.turret);
                ItemStack itemstack = slotStack;
                this.upgradeStacks.set(slot, ItemStackUtils.getEmpty());
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = slotStack.func_77979_a(amount);
            if (slotStack.field_77994_a == 0) {
                this.upgradeStacks.set(slot, ItemStackUtils.getEmpty());
            }
            this.func_70296_d();
            return itemstack;
        }
        return ItemStackUtils.getEmpty();
    }

    public ItemStack func_70304_b(int slot) {
        if (ItemStackUtils.isValid((ItemStack)this.upgradeStacks.get(slot))) {
            ItemStack itemstack = this.upgradeStacks.get(slot);
            this.upgradeStacks.set(slot, ItemStackUtils.getEmpty());
            return itemstack;
        }
        return ItemStackUtils.getEmpty();
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack slotStack = this.upgradeStacks.get(slot);
        if (!ItemStackUtils.areEqual((ItemStack)slotStack, (ItemStack)stack)) {
            ITurretUpgrade upg;
            if (ItemStackUtils.isValid((ItemStack)slotStack)) {
                upg = UpgradeRegistry.INSTANCE.getUpgrade(slotStack);
                upg.onRemove(this.turret);
            }
            if (ItemStackUtils.isValid((ItemStack)stack)) {
                upg = UpgradeRegistry.INSTANCE.getUpgrade(stack);
                upg.onApply(this.turret);
            }
        }
        this.upgradeStacks.set(slot, stack);
        if (ItemStackUtils.isValid((ItemStack)stack) && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "Upgrades";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.hasChanged = true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot >= 9 && !this.hasUpgrade(Upgrades.UPG_STORAGE_I)) {
            return false;
        }
        if (slot >= 18 && !this.hasUpgrade(Upgrades.UPG_STORAGE_II)) {
            return false;
        }
        if (slot >= 27 && !this.hasUpgrade(Upgrades.UPG_STORAGE_III)) {
            return false;
        }
        if (ItemStackUtils.isValid((ItemStack)this.upgradeStacks.get(slot))) {
            return false;
        }
        if (stack.func_77973_b() == ItemRegistry.TURRET_UPGRADE) {
            ITurretUpgrade upg = UpgradeRegistry.INSTANCE.getUpgrade(stack);
            if (this.hasUpgrade(UpgradeRegistry.INSTANCE.getUpgradeId(upg))) {
                return false;
            }
            ITurretUpgrade dep = upg.getDependantOn();
            return dep == null || this.hasUpgrade(dep);
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.upgradeStacks.clear();
    }

    @Override
    public boolean tryApplyUpgrade(ItemStack upgStack) {
        ITurretUpgrade dep;
        ITurretUpgrade upg = UpgradeRegistry.INSTANCE.getUpgrade(upgStack);
        if (!this.hasUpgrade(upg) && ((dep = upg.getDependantOn()) == null || this.hasUpgrade(dep))) {
            EntityLiving turretL = this.turret.getEntity();
            int max = this.upgradeStacks.size();
            for (int i = 0; i < max; ++i) {
                if (!this.func_94041_b(i, upgStack)) continue;
                this.func_70299_a(i, upgStack);
                PacketRegistry.sendToAllAround((IMessage)new PacketUpdateUgradeSlot(this.turret, i, upgStack), turretL.field_71093_bK, turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, 64.0);
                return true;
            }
        }
        return false;
    }

    public void dropUpgrades() {
        EntityLiving turretL = this.turret.getEntity();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70304_b(i);
            if (!ItemStackUtils.isValid((ItemStack)stack)) continue;
            float xOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            float yOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            float zOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(turretL.field_70170_p, turretL.field_70165_t + (double)xOff, turretL.field_70163_u + (double)yOff, turretL.field_70161_v + (double)zOff, stack);
            float motionSpeed = 0.05f;
            entityitem.field_70159_w = (float)MiscUtils.RNG.randomGaussian() * motionSpeed;
            entityitem.field_70181_x = (float)MiscUtils.RNG.randomGaussian() * motionSpeed + 0.2f;
            entityitem.field_70179_y = (float)MiscUtils.RNG.randomGaussian() * motionSpeed;
            turretL.field_70170_p.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74782_a("upgInventory", (NBTBase)ItemStackUtils.writeItemStacksToTag(this.upgradeStacks, (int)1, this::callbackWriteUpgStack));
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        ItemStackUtils.readItemStacksFromTag(this.upgradeStacks, (NBTTagList)nbt.func_150295_c("upgInventory", 10), this::callbackReadUpgStack);
    }

    @Override
    public void syncUpgrade(UUID id) {
        EntityLiving turretL = this.turret.getEntity();
        if (!turretL.field_70170_p.field_72995_K) {
            PacketRegistry.sendToAllAround((IMessage)new PacketSyncUpgradeInst(this.turret, id), turretL.field_70170_p.field_73011_w.getDimension(), turretL.field_70165_t, turretL.field_70163_u, turretL.field_70161_v, 64.0);
        }
    }

    private void callbackWriteUpgStack(ItemStack upgStack, NBTTagCompound nbt) {
        ITurretUpgrade upg = UpgradeRegistry.INSTANCE.getUpgrade(upgStack);
        upg.onSave(this.turret, nbt);
    }

    private void callbackReadUpgStack(ItemStack upgStack, NBTTagCompound nbt) {
        ITurretUpgrade upg = UpgradeRegistry.INSTANCE.getUpgrade(upgStack);
        upg.onLoad(this.turret, nbt);
    }
}

