/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.event;

import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldHandler;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.TurretForcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.function.Predicate;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ExplosionEventHandler {
    private static final Predicate<EntityLivingBase> CHK_ENTITY = entity -> {
        if (entity instanceof ITurretInst) {
            ITurretInst turretInst = (ITurretInst)entity;
            return turretInst.getTurret() instanceof TurretForcefield && turretInst.getUpgradeProcessor().hasUpgrade(Upgrades.SHIELD_EXPLOSIVE);
        }
        return false;
    };

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        float radius = event.getExplosion().field_77280_f;
        Vec3d expPos = event.getExplosion().getPosition();
        AxisAlignedBB aabb = new AxisAlignedBB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).func_186662_g(24.0).func_72317_d(expPos.field_72450_a, expPos.field_72448_b, expPos.field_72449_c);
        for (EntityLivingBase living : event.getWorld().func_175647_a(EntityLivingBase.class, aabb, CHK_ENTITY::test)) {
            ShieldHandler.onExplosion((ITurretInst)living, aabb, event.getAffectedBlocks(), event.getAffectedEntities());
        }
    }
}

