/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.event;

import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.event.TargetingEvent;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.registry.turret.TurretCryolator;
import de.sanandrew.mods.turretmod.registry.turret.TurretShotgun;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldHandler;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.TurretForcefield;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.registry.upgrades.smartTargeting.AdvTargetSettings;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TargetingEventHandler {
    @SubscribeEvent
    public void onProcessorTick(TargetingEvent.ProcessorTick event) {
        ITurretInst turretInst = event.processor.getTurret();
        if (turretInst.getTurret() instanceof TurretForcefield) {
            event.setCanceled(true);
            ShieldHandler.onTargeting(turretInst, event.processor);
        }
    }

    @SubscribeEvent
    public void onTargetCheck(TargetingEvent.TargetCheck event) {
        List<Entity> entities;
        AdvTargetSettings settings;
        ITurretInst turretInst = event.processor.getTurret();
        if (turretInst.getTurret() instanceof TurretCryolator && event.target instanceof EntityLivingBase && ((EntityLivingBase)event.target).func_70644_a(MobEffects.field_76421_d)) {
            event.setResult(Event.Result.DENY);
        }
        if (event.processor.getTurret().getUpgradeProcessor().hasUpgrade(Upgrades.SMART_TGT) && (settings = (AdvTargetSettings)event.processor.getTurret().getUpgradeProcessor().getUpgradeInstance(Upgrades.SMART_TGT)) != null && !settings.isTargetValid(event.target, turretInst, entities = turretInst.getTargetProcessor().getValidTargetList())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onShooting(TargetingEvent.Shooting event) {
        if (event.processor.getTurret() instanceof TurretShotgun) {
            if (event.processor.hasAmmo()) {
                for (int i = 0; i < 6; ++i) {
                    Entity projectile = event.processor.getProjectile();
                    assert (projectile != null);
                    event.processor.getTurret().getEntity().field_70170_p.func_72838_d(projectile);
                }
                event.processor.playSound(event.processor.getTurret().getShootSound(), 1.8f);
                event.processor.getTurret().setShooting();
                event.processor.decrAmmo();
                event.setResult(Event.Result.ALLOW);
            } else {
                event.processor.playSound(event.processor.getTurret().getNoAmmoSound(), 1.0f);
                event.setResult(Event.Result.DENY);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAmmoConsumption(TargetingEvent.ConsumeAmmo event) {
        ITurretInst turret = event.processor.getTurret();
        if (turret.getUpgradeProcessor().hasUpgrade(Upgrades.ECONOMY_INF) && event.processor.getAmmoCount() == event.processor.getMaxAmmoCapacity()) {
            event.setResult(Event.Result.DENY);
        } else {
            if (turret.getUpgradeProcessor().hasUpgrade(Upgrades.ECONOMY_I) && MiscUtils.RNG.randomFloat() < 0.1f) {
                event.setResult(Event.Result.DENY);
            }
            if (turret.getUpgradeProcessor().hasUpgrade(Upgrades.ECONOMY_II) && MiscUtils.RNG.randomFloat() < 0.35f) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

