/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.TmrCreativeTabs;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemAssemblyUpgrade
extends Item {
    public ItemAssemblyUpgrade() {
        this.func_77637_a(TmrCreativeTabs.UPGRADES);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer worldIn, List<String> tooltip, boolean flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(Lang.translate(this.func_77658_a() + ".ttip", new Object[0]));
    }

    public static class Filter
    extends ItemAssemblyUpgrade {
        public Filter() {
            this.func_77655_b("sapturretmod:turret_assembly_filter");
            this.setRegistryName("sapturretmod", "assembly_upg_filter");
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, EntityPlayer worldIn, List<String> tooltip, boolean flagIn) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_74764_b("filteredStacks")) {
                tooltip.add(TextFormatting.ITALIC + Lang.translate(this.func_77658_a() + ".conf", new Object[0]));
            } else {
                tooltip.add(Lang.translate(this.func_77658_a() + ".inst", new Object[0]));
            }
        }

        public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
            if (!world.field_72995_K) {
                if (player.func_70093_af()) {
                    Filter.setFilterStacks(player.func_184586_b(hand), null);
                    player.field_71069_bz.func_75142_b();
                } else {
                    TurretModRebirth.proxy.openGui(player, EnumGui.GUI_TASSEMBLY_FLT, 0, 0, 0);
                }
            }
            return super.func_77659_a(stack, world, player, hand);
        }

        public static List<ItemStack> getFilterStacks(ItemStack stack) {
            List<ItemStack> stacks = Filter.getEmptyInv();
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_74764_b("filteredStacks")) {
                ItemStackUtils.readItemStacksFromTag(stacks, (NBTTagList)nbt.func_150295_c("filteredStacks", 10));
            }
            return stacks;
        }

        public static void setFilterStacks(ItemStack stack, List<ItemStack> inv) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            if (inv == null || inv.size() < 1) {
                if (nbt.func_74764_b("filteredStacks")) {
                    nbt.func_82580_o("filteredStacks");
                }
            } else {
                NBTTagList list = ItemStackUtils.writeItemStacksToTag(inv, (int)1);
                nbt.func_74782_a("filteredStacks", (NBTBase)list);
            }
            stack.func_77982_d(nbt);
        }

        public static List<ItemStack> getEmptyInv() {
            return new ArrayList<Object>(Collections.nCopies(18, null));
        }
    }

    public static class Speed
    extends ItemAssemblyUpgrade {
        public Speed() {
            this.func_77655_b("sapturretmod:turret_assembly_speed");
            this.setRegistryName("sapturretmod", "assembly_upg_speed");
        }
    }

    public static class Automation
    extends ItemAssemblyUpgrade {
        public Automation() {
            this.func_77655_b("sapturretmod:turret_assembly_auto");
            this.setRegistryName("sapturretmod", "assembly_upg_auto");
        }
    }
}

