/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.item;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.entity.turret.EntityTurret;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.TmrCreativeTabs;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockLiquid;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTurret
extends Item {
    private static final IItemPropertyGetter TURRET_TEX_ID = (stack, worldIn, entityIn) -> TurretRegistry.INSTANCE.getTurrets().indexOf(TurretRegistry.INSTANCE.getTurret(stack));

    public ItemTurret() {
        this.func_77637_a(TmrCreativeTabs.TURRETS);
        this.func_77655_b("sapturretmod:turret_placer");
        this.func_185043_a(new ResourceLocation("turretId"), TURRET_TEX_ID);
        this.setRegistryName("sapturretmod", "turret_placer");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer worldIn, List<String> tooltip, boolean flagIn) {
        Float health;
        String name;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        ITurret turret = TurretRegistry.INSTANCE.getTurret(stack);
        if (turret != null) {
            tooltip.add(Lang.translate(Lang.TURRET_NAME.get(turret.getName()), new Object[0]));
        }
        if ((name = ItemTurret.getTurretName(stack)) != null) {
            tooltip.add(String.format(Lang.translate("%s.turret_name", this.func_77658_a()), name));
        }
        if ((health = ItemTurret.getTurretHealth(stack)) != null) {
            tooltip.add(String.format(Lang.translate("%s.health", this.func_77658_a()), health));
        }
    }

    public EnumActionResult func_180614_a(ItemStack stackPar, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack;
            EntityTurret turret;
            BlockPos placingOn = pos.func_177982_a(facing.func_82601_c(), 0, facing.func_82599_e());
            if (facing.func_96559_d() == 0) {
                placingOn = placingOn.func_177972_a(EnumFacing.DOWN);
                facing = EnumFacing.UP;
                if (world.func_180495_p(placingOn).func_177230_c().func_176200_f((IBlockAccess)world, placingOn)) {
                    placingOn = placingOn.func_177967_a(EnumFacing.UP, 2);
                    facing = EnumFacing.DOWN;
                }
            }
            int shiftY = facing == EnumFacing.UP ? 1 : -1;
            if (EntityTurret.canTurretBePlaced(world, placingOn, false, facing == EnumFacing.DOWN) && (turret = ItemTurret.spawnTurret(world, TurretRegistry.INSTANCE.getTurret(stack = player.func_184586_b(hand)), (double)placingOn.func_177958_n() + 0.5, placingOn.func_177956_o() + shiftY, (double)placingOn.func_177952_p() + 0.5, facing == EnumFacing.DOWN, player)) != null) {
                String name;
                Float initHealth = ItemTurret.getTurretHealth(stack);
                if (initHealth != null) {
                    turret.func_70606_j(initHealth.floatValue());
                }
                if ((name = ItemTurret.getTurretName(stack)) != null) {
                    turret.func_96094_a(name);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stackPar, World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult traceResult;
        ItemStack stack = player.func_184586_b(hand);
        if (ItemStackUtils.isValid((ItemStack)stack) && !world.field_72995_K && (traceResult = this.func_77621_a(world, player, true)) != null && traceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            EntityTurret turret;
            BlockPos blockPos = traceResult.func_178782_a();
            if (!world.func_175660_a(player, blockPos)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (!player.func_175151_a(blockPos, traceResult.field_178784_b, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (world.func_180495_p(blockPos).func_177230_c() instanceof BlockLiquid && (turret = ItemTurret.spawnTurret(world, TurretRegistry.INSTANCE.getTurret(stack), blockPos, false, player)) != null) {
                String name;
                Float initHealth = ItemTurret.getTurretHealth(stack);
                if (initHealth != null) {
                    turret.func_70606_j(initHealth.floatValue());
                }
                if ((name = ItemTurret.getTurretName(stack)) != null) {
                    turret.func_96094_a(name);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_150895_a(Item tab, CreativeTabs tabs, List<ItemStack> items) {
        items.addAll(TurretRegistry.INSTANCE.getTurrets().stream().map(TurretRegistry.INSTANCE::getTurretItem).collect(Collectors.toList()));
    }

    public static Float getTurretHealth(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("turretHealth")) {
            return Float.valueOf(nbt.func_74760_g("turretHealth"));
        }
        return null;
    }

    public static String getTurretName(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("turretName")) {
            return nbt.func_74779_i("turretName");
        }
        if (stack.func_82837_s()) {
            return stack.func_82833_r();
        }
        return null;
    }

    private static EntityTurret spawnTurret(World world, ITurret turret, BlockPos pos, boolean isUpsideDown, EntityPlayer owner) {
        return ItemTurret.spawnTurret(world, turret, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), isUpsideDown, owner);
    }

    private static EntityTurret spawnTurret(World world, ITurret turret, double x, double y, double z, boolean isUpsideDown, EntityPlayer owner) {
        EntityTurret turretE = new EntityTurret(world, isUpsideDown, owner, turret);
        turretE.func_70012_b(x, y - (isUpsideDown ? 1.0 : 0.0), z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        turretE.field_70759_as = turretE.field_70177_z;
        turretE.field_70761_aq = turretE.field_70177_z;
        world.func_72838_d((Entity)turretE);
        turretE.func_70642_aH();
        return turretE;
    }
}

