/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.registry.turret.GuiTcuRegistry;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class PacketSyncTcuGuis
extends AbstractMessage<PacketSyncTcuGuis> {
    private Map<Integer, ResourceLocation> guis = new TreeMap<Integer, ResourceLocation>();

    public PacketSyncTcuGuis() {
        int max = GuiTcuRegistry.GUI_RESOURCES.size();
        for (int i = 0; i < max; ++i) {
            this.guis.put(i, GuiTcuRegistry.GUI_RESOURCES.get(i));
        }
    }

    public void handleClientMessage(PacketSyncTcuGuis packet, EntityPlayer player) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GuiTcuRegistry.GUI_RESOURCES.clear();
            packet.guis.forEach((pos, gui) -> {
                if (GuiTcuRegistry.GUI_RESOURCES.size() >= pos) {
                    GuiTcuRegistry.GUI_RESOURCES.add((ResourceLocation)gui);
                } else {
                    GuiTcuRegistry.GUI_RESOURCES.set((int)pos, (ResourceLocation)gui);
                }
            });
        }
    }

    public void handleServerMessage(PacketSyncTcuGuis packet, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.guis = new HashMap<Integer, ResourceLocation>(size);
        for (int i = 0; i < size; ++i) {
            this.guis.put(i, new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.guis.size());
        this.guis.forEach((pos, gui) -> {
            buf.writeInt(pos.intValue());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)gui.toString());
        });
    }
}

