/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.TileClientSync;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSyncTileEntity
extends AbstractMessage<PacketSyncTileEntity> {
    private BlockPos pos;
    private byte[] tileBytes;

    public PacketSyncTileEntity() {
    }

    public PacketSyncTileEntity(TileClientSync tile) {
        this.pos = tile.getTile().func_174877_v();
        ByteBuf buf = Unpooled.buffer();
        tile.toBytes(buf);
        this.tileBytes = buf.array();
    }

    public void handleClientMessage(PacketSyncTileEntity packet, EntityPlayer player) {
        assert (player != null);
        assert (player.field_70170_p != null);
        TileEntity te = player.field_70170_p.func_175625_s(new BlockPos((Vec3i)packet.pos));
        if (te instanceof TileClientSync) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])packet.tileBytes);
            ((TileClientSync)te).fromBytes(buf);
        }
    }

    public void handleServerMessage(PacketSyncTileEntity packet, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int arrSz = buf.readInt();
        this.tileBytes = new byte[arrSz];
        buf.readBytes(this.tileBytes, 0, arrSz);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.tileBytes.length);
        buf.writeBytes(this.tileBytes);
    }

    public static void sync(TileClientSync te) {
        TileEntity tile = te.getTile();
        PacketRegistry.sendToAllAround((IMessage)new PacketSyncTileEntity(te), tile.func_145831_w().field_73011_w.getDimension(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), 64.0);
    }
}

