/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.Level;

public class PacketSyncUpgradeInst
extends AbstractMessage<PacketSyncUpgradeInst> {
    private int turretId;
    private UUID upgradeId;
    private byte[] instData;

    public PacketSyncUpgradeInst() {
    }

    public PacketSyncUpgradeInst(ITurretInst turret, UUID upgradeId) {
        this.turretId = turret.getEntity().func_145782_y();
        this.upgradeId = upgradeId;
        Object upgInstance = turret.getUpgradeProcessor().getUpgradeInstance(upgradeId);
        if (upgInstance != null) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(bos);){
                upgInstance.toBytes(oos);
                oos.close();
                this.instData = bos.toByteArray();
            }
            catch (IOException e) {
                TmrConstants.LOG.log(Level.ERROR, "Cannot sync upgrade instance", (Throwable)e);
            }
        }
    }

    public void handleClientMessage(PacketSyncUpgradeInst packet, EntityPlayer player) {
        this.handleServerMessage(packet, player);
    }

    public void handleServerMessage(PacketSyncUpgradeInst packet, EntityPlayer player) {
        Entity e;
        if (packet.instData.length > 0 && (e = player.field_70170_p.func_73045_a(packet.turretId)) instanceof ITurretInst) {
            IUpgradeProcessor processor = ((ITurretInst)e).getUpgradeProcessor();
            Object upgInstance = processor.getUpgradeInstance(packet.upgradeId);
            if (upgInstance != null) {
                try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(packet.instData));){
                    upgInstance.fromBytes(ois);
                }
                catch (IOException ex) {
                    TmrConstants.LOG.log(Level.ERROR, "Cannot sync upgrade instance", (Throwable)ex);
                }
            } else {
                TmrConstants.LOG.log(Level.ERROR, "Cannot sync upgrade instance from upgrade ID {0}; it has no default instance available!");
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.turretId = buf.readInt();
        this.upgradeId = new UUID(buf.readLong(), buf.readLong());
        int lng = buf.readInt();
        this.instData = new byte[lng];
        if (lng > 0) {
            buf.readBytes(this.instData);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.turretId);
        buf.writeLong(this.upgradeId.getMostSignificantBits());
        buf.writeLong(this.upgradeId.getLeastSignificantBits());
        buf.writeInt(this.instData.length);
        buf.writeBytes(this.instData);
    }
}

