/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.network;

import de.sanandrew.mods.sanlib.lib.network.AbstractMessage;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateTargets
extends AbstractMessage<PacketUpdateTargets> {
    private List<Class<? extends Entity>> entityTargets;
    private UUID[] playerTargets;
    private boolean isBlacklistEntity;
    private boolean isBlacklistPlayer;
    private int turretID;

    public PacketUpdateTargets() {
    }

    public PacketUpdateTargets(ITargetProcessor processor) {
        this.entityTargets = processor.getEnabledEntityTargets();
        this.playerTargets = processor.getEnabledPlayerTargets();
        this.isBlacklistEntity = processor.isEntityBlacklist();
        this.isBlacklistPlayer = processor.isPlayerBlacklist();
        this.turretID = processor.getTurret().getEntity().func_145782_y();
    }

    public void handleClientMessage(PacketUpdateTargets packet, EntityPlayer player) {
        this.handleServerMessage(packet, player);
    }

    public void handleServerMessage(PacketUpdateTargets packet, EntityPlayer player) {
        Entity e = player.field_70170_p.func_73045_a(packet.turretID);
        if (e instanceof ITurretInst) {
            ITargetProcessor processor = ((ITurretInst)e).getTargetProcessor();
            processor.updateEntityTargets(packet.entityTargets);
            processor.updatePlayerTargets(packet.playerTargets);
            processor.setEntityBlacklist(packet.isBlacklistEntity);
            processor.setPlayerBlacklist(packet.isBlacklistPlayer);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.turretID = buf.readInt();
        this.entityTargets = new ArrayList<Class<? extends Entity>>();
        int max = buf.readInt();
        for (i = 0; i < max; ++i) {
            try {
                this.entityTargets.add(Class.forName(ByteBufUtils.readUTF8String((ByteBuf)buf)));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.playerTargets = new UUID[buf.readInt()];
        for (i = 0; i < this.playerTargets.length; ++i) {
            try {
                this.playerTargets[i] = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.playerTargets[i] = null;
            }
        }
        this.isBlacklistEntity = buf.readBoolean();
        this.isBlacklistPlayer = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.turretID);
        buf.writeInt(this.entityTargets.size());
        for (Class<? extends Entity> entityTarget : this.entityTargets) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entityTarget.getName());
        }
        buf.writeInt(this.playerTargets.length);
        for (UUID playerTarget : this.playerTargets) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)playerTarget.toString());
        }
        buf.writeBoolean(this.isBlacklistEntity);
        buf.writeBoolean(this.isBlacklistPlayer);
    }
}

