/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.ammo.IAmmunitionRegistry;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Level;

public final class AmmunitionRegistry
implements IAmmunitionRegistry {
    public static final AmmunitionRegistry INSTANCE = new AmmunitionRegistry();
    private final Map<UUID, IAmmunition> ammoTypesFromUUID = new HashMap<UUID, IAmmunition>();
    private final Multimap<ITurret, IAmmunition> ammoTypesFromTurret = ArrayListMultimap.create();
    private final Map<UUID, List<IAmmunition>> ammoGroupsFromUUID = new LinkedHashMap<UUID, List<IAmmunition>>();
    private final List<IAmmunition> ammoTypes = new ArrayList<IAmmunition>();
    public static final IAmmunition NULL_TYPE = new IAmmunition<EntityArrow>(){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public UUID getId() {
            return UuidUtils.EMPTY_UUID;
        }

        @Override
        public UUID getTypeId() {
            return UuidUtils.EMPTY_UUID;
        }

        @Override
        public UUID getGroupId() {
            return UuidUtils.EMPTY_UUID;
        }

        @Override
        public String getInfoName() {
            return "";
        }

        @Override
        public float getInfoDamage() {
            return 0.0f;
        }

        @Override
        public int getAmmoCapacity() {
            return 0;
        }

        @Override
        public Class<EntityArrow> getEntityClass() {
            return null;
        }

        @Override
        public EntityArrow getEntity(ITurretInst turretInst) {
            return null;
        }

        @Override
        public ITurret getTurret() {
            return null;
        }

        @Override
        public ResourceLocation getModel() {
            return null;
        }

        @Override
        public ItemStack getStoringAmmoItem() {
            return ItemStackUtils.getEmpty();
        }
    };

    private AmmunitionRegistry() {
    }

    @Override
    public List<IAmmunition> getRegisteredTypes() {
        return new ArrayList<IAmmunition>(this.ammoTypes);
    }

    @Override
    public List<UUID> getGroups() {
        return new ArrayList<UUID>(this.ammoGroupsFromUUID.keySet());
    }

    @Override
    public IAmmunition[] getTypes(UUID groupId) {
        List ammoList = (List)MiscUtils.defIfNull(this.ammoGroupsFromUUID.get(groupId), new ArrayList(0));
        return ammoList.toArray(new IAmmunition[ammoList.size()]);
    }

    @Override
    public IAmmunition getType(UUID typeId) {
        return (IAmmunition)MiscUtils.defIfNull((Object)this.ammoTypesFromUUID.get(typeId), (Object)NULL_TYPE);
    }

    @Override
    public IAmmunition getType(ItemStack stack) {
        NBTTagCompound nbt;
        if (ItemStackUtils.isValid((ItemStack)stack) && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("ammoType")) {
            String typeUUID = nbt.func_74779_i("ammoType");
            try {
                return this.getType(UUID.fromString(typeUUID));
            }
            catch (IllegalArgumentException ex) {
                return NULL_TYPE;
            }
        }
        return NULL_TYPE;
    }

    @Override
    public List<IAmmunition> getTypesForTurret(ITurret turret) {
        return new ArrayList<IAmmunition>(this.ammoTypesFromTurret.get((Object)turret));
    }

    @Override
    public boolean registerAmmoType(IAmmunition<?> type) {
        return this.registerAmmoType(type, null);
    }

    @Override
    public ItemStack getAmmoItem(IAmmunition type) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot get turret_ammo item with NULL type!");
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("ammoType", type.getId().toString());
        ItemStack stack = new ItemStack((Item)ItemRegistry.TURRET_AMMO, 1);
        stack.func_77982_d(nbt);
        return stack;
    }

    boolean registerAmmoType(IAmmunition<?> type, Integer registerEntityId) {
        if (type == null) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot register NULL as Ammo-Type!", (Throwable)new InvalidParameterException());
            return false;
        }
        if (type.getName() == null || type.getName().isEmpty()) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Ammo-Type %s has an empty/NULL name! Cannot register the Void.", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        if (this.ammoTypesFromUUID.containsKey(type.getId())) {
            TmrConstants.LOG.log(Level.ERROR, String.format("The UUID of Ammo-Type %s is already registered! Use another UUID. JUST DO IT!", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        if (type.getAmmoCapacity() < 1) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Ammo-Type %s provides less than 1 round! At least give it SOMETHING...", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        if (type.getTurret() == null) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Ammo-Type %s has no turret_placer! Ammo is pretty useless without something to shoot it with.", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        this.ammoTypesFromUUID.put(type.getId(), type);
        this.ammoTypesFromTurret.put((Object)type.getTurret(), type);
        this.ammoTypes.add(type);
        if (registerEntityId != null) {
            String name = "turret_proj_".concat(type.getName());
            EntityRegistry.registerModEntity(type.getEntityClass(), (String)("sapturretmod." + name), (int)registerEntityId, (Object)TurretModRebirth.instance, (int)128, (int)1, (boolean)true);
        }
        UUID grpId = type.getGroupId();
        List groupList = this.ammoGroupsFromUUID.computeIfAbsent(grpId, k -> new ArrayList());
        groupList.add(type);
        return true;
    }

    @Override
    public boolean areAmmoItemsEqual(ItemStack firstStack, ItemStack secondStack) {
        if (firstStack.func_77973_b() == ItemRegistry.TURRET_AMMO && secondStack.func_77973_b() == ItemRegistry.TURRET_AMMO) {
            IAmmunition firstType = this.getType(firstStack);
            IAmmunition secondType = this.getType(secondStack);
            return firstType != NULL_TYPE && secondType != NULL_TYPE && firstType.getTypeId().equals(secondType.getTypeId());
        }
        return firstStack == secondStack;
    }
}

