/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileFlame;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.Ammunitions;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TurretAmmoFireTank
implements IAmmunition<EntityProjectileFlame> {
    private final String name;
    private final UUID id;
    private final int capacity;
    private final ResourceLocation itemModel;

    public TurretAmmoFireTank(boolean isMulti) {
        this.name = isMulti ? "fueltank_pack" : "fueltank";
        this.id = isMulti ? Ammunitions.FUELTANK_PACK : Ammunitions.FUELTANK;
        this.capacity = isMulti ? 256 : 16;
        this.itemModel = new ResourceLocation("sapturretmod", "turret_ammo/" + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public int getAmmoCapacity() {
        return this.capacity;
    }

    @Override
    public Class<EntityProjectileFlame> getEntityClass() {
        return EntityProjectileFlame.class;
    }

    @Override
    public ITurret getTurret() {
        return Turrets.FLAMETHROWER;
    }

    @Override
    public float getInfoDamage() {
        return 0.5f;
    }

    @Override
    public UUID getTypeId() {
        return Ammunitions.FUELTANK;
    }

    @Override
    public UUID getGroupId() {
        return Ammunitions.FUELTANK;
    }

    @Override
    public String getInfoName() {
        return "fueltank";
    }

    @Override
    public ItemStack getStoringAmmoItem() {
        return AmmunitionRegistry.INSTANCE.getAmmoItem(AmmunitionRegistry.INSTANCE.getType(Ammunitions.FUELTANK));
    }

    @Override
    public EntityProjectileFlame getEntity(ITurretInst turretInst) {
        EntityProjectileFlame flame = new EntityProjectileFlame(turretInst.getEntity().field_70170_p, (Entity)turretInst.getEntity(), turretInst.getTargetProcessor().getTarget());
        flame.purifying = turretInst.getUpgradeProcessor().hasUpgrade(Upgrades.FUEL_PURIFY);
        return flame;
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }
}

