/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileLaser;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.Ammunitions;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TurretAmmoFluxCell
implements IAmmunition<EntityProjectileLaser> {
    private final String name;
    private final UUID id;
    private final int capacity;
    private final ResourceLocation itemModel;

    public TurretAmmoFluxCell(boolean isMulti) {
        this.name = isMulti ? "fluxcell_pack" : "fluxcell";
        this.id = isMulti ? Ammunitions.FLUXCELL_PACK : Ammunitions.FLUXCELL;
        this.capacity = isMulti ? 16 : 1;
        this.itemModel = new ResourceLocation("sapturretmod", "turret_ammo/" + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public int getAmmoCapacity() {
        return this.capacity;
    }

    @Override
    public Class<EntityProjectileLaser> getEntityClass() {
        return EntityProjectileLaser.class;
    }

    @Override
    public ITurret getTurret() {
        return Turrets.LASER;
    }

    @Override
    public float getInfoDamage() {
        return 2.5f;
    }

    @Override
    public UUID getTypeId() {
        return Ammunitions.FLUXCELL;
    }

    @Override
    public UUID getGroupId() {
        return Ammunitions.FLUXCELL;
    }

    @Override
    public String getInfoName() {
        return "fluxcell";
    }

    @Override
    public ItemStack getStoringAmmoItem() {
        return AmmunitionRegistry.INSTANCE.getAmmoItem(AmmunitionRegistry.INSTANCE.getType(Ammunitions.FLUXCELL));
    }

    @Override
    public EntityProjectileLaser getEntity(ITurretInst turretInst) {
        return new EntityProjectileLaser(turretInst.getEntity().field_70170_p, (Entity)turretInst.getEntity(), turretInst.getTargetProcessor().getTarget());
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }
}

