/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectileMinigunPebble;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.Ammunitions;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TurretAmmoMinigunShell
implements IAmmunition<EntityProjectileMinigunPebble> {
    private final String name;
    private final UUID id;
    private final int capacity;
    private final ResourceLocation itemModel;

    public TurretAmmoMinigunShell(boolean isMulti) {
        this.name = isMulti ? "minigun_shell_pack" : "minigun_shell";
        this.id = isMulti ? Ammunitions.MGSHELL_PACK : Ammunitions.MGSHELL;
        this.capacity = isMulti ? 64 : 4;
        this.itemModel = new ResourceLocation("sapturretmod", "turret_ammo/" + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public int getAmmoCapacity() {
        return this.capacity;
    }

    @Override
    public Class<EntityProjectileMinigunPebble> getEntityClass() {
        return EntityProjectileMinigunPebble.class;
    }

    @Override
    public ITurret getTurret() {
        return Turrets.MINIGUN;
    }

    @Override
    public float getInfoDamage() {
        return 0.3f;
    }

    @Override
    public UUID getTypeId() {
        return Ammunitions.MGSHELL;
    }

    @Override
    public UUID getGroupId() {
        return Ammunitions.MGSHELL;
    }

    @Override
    public String getInfoName() {
        return "minigun_shell";
    }

    @Override
    public ItemStack getStoringAmmoItem() {
        return AmmunitionRegistry.INSTANCE.getAmmoItem(AmmunitionRegistry.INSTANCE.getType(Ammunitions.MGSHELL));
    }

    @Override
    public EntityProjectileMinigunPebble getEntity(ITurretInst turretInst) {
        return new EntityProjectileMinigunPebble(turretInst.getEntity().field_70170_p, (Entity)turretInst.getEntity(), turretInst.getTargetProcessor().getTarget());
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }
}

