/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.ammo;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.entity.projectile.EntityProjectilePebble;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.Ammunitions;
import de.sanandrew.mods.turretmod.registry.turret.Turrets;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TurretAmmoShotgunShell
implements IAmmunition<EntityProjectilePebble> {
    private final String name;
    private final UUID id;
    private final int capacity;
    private final ResourceLocation itemModel;

    public TurretAmmoShotgunShell(boolean isMulti) {
        this.name = isMulti ? "shotgun_shell_pack" : "shotgun_shell";
        this.id = isMulti ? Ammunitions.SGSHELL_PACK : Ammunitions.SGSHELL;
        this.capacity = isMulti ? 16 : 1;
        this.itemModel = new ResourceLocation("sapturretmod", "turret_ammo/" + this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public int getAmmoCapacity() {
        return this.capacity;
    }

    @Override
    public Class<EntityProjectilePebble> getEntityClass() {
        return EntityProjectilePebble.class;
    }

    @Override
    public ITurret getTurret() {
        return Turrets.SHOTGUN;
    }

    @Override
    public float getInfoDamage() {
        return 0.5f;
    }

    @Override
    public UUID getTypeId() {
        return Ammunitions.SGSHELL;
    }

    @Override
    public UUID getGroupId() {
        return Ammunitions.SGSHELL;
    }

    @Override
    public String getInfoName() {
        return "shotgun_shell";
    }

    @Override
    public ItemStack getStoringAmmoItem() {
        return AmmunitionRegistry.INSTANCE.getAmmoItem(AmmunitionRegistry.INSTANCE.getType(Ammunitions.SGSHELL));
    }

    @Override
    public EntityProjectilePebble getEntity(ITurretInst turretInst) {
        return new EntityProjectilePebble(turretInst.getEntity().field_70170_p, (Entity)turretInst.getEntity(), turretInst.getTargetProcessor().getTarget());
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }
}

