/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.assembly;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.assembly.IRecipeEntry;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class RecipeEntry
implements IRecipeEntry {
    public int stackSize;
    public ItemStack[] normalAlternatives;
    public String[] oreDictAlternatives;
    private boolean drawTooltip;
    private WeakReference<ItemStack[]> cachedEntryStacks;

    public RecipeEntry(int count) {
        this.stackSize = count;
        this.drawTooltip = false;
        this.normalAlternatives = new ItemStack[0];
        this.oreDictAlternatives = new String[0];
    }

    private RecipeEntry(int count, ItemStack[] normalAlternatives, String[] oreDictAlternatives) {
        this.stackSize = count;
        this.drawTooltip = false;
        this.normalAlternatives = normalAlternatives;
        this.oreDictAlternatives = oreDictAlternatives;
    }

    @Override
    public RecipeEntry put(Item ... items) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        newStacks.addAll(Arrays.asList(this.normalAlternatives));
        for (Item item : items) {
            newStacks.add(new ItemStack(item, 1));
        }
        this.normalAlternatives = newStacks.toArray(new ItemStack[newStacks.size()]);
        return this;
    }

    @Override
    public RecipeEntry put(Block ... blocks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        newStacks.addAll(Arrays.asList(this.normalAlternatives));
        for (Block block : blocks) {
            newStacks.add(new ItemStack(block, 1));
        }
        this.normalAlternatives = newStacks.toArray(new ItemStack[newStacks.size()]);
        return this;
    }

    @Override
    public RecipeEntry put(ItemStack ... stacks) {
        ArrayList<ItemStack> newStacks = new ArrayList<ItemStack>();
        newStacks.addAll(Arrays.asList(this.normalAlternatives));
        newStacks.addAll(Arrays.asList(stacks));
        this.normalAlternatives = newStacks.toArray(new ItemStack[newStacks.size()]);
        return this;
    }

    @Override
    public RecipeEntry put(String ... oreDictNames) {
        ArrayList<String> newNames = new ArrayList<String>();
        newNames.addAll(Arrays.asList(this.oreDictAlternatives));
        for (String name : oreDictNames) {
            if (name.endsWith("*")) {
                name = name.substring(0, name.lastIndexOf(42));
                for (String oreName : OreDictionary.getOreNames()) {
                    if (!oreName.startsWith(name)) continue;
                    newNames.add(oreName);
                }
                continue;
            }
            newNames.add(name);
        }
        this.oreDictAlternatives = newNames.toArray(new String[newNames.size()]);
        return this;
    }

    @Override
    public RecipeEntry drawTooltip() {
        this.drawTooltip = true;
        return this;
    }

    @Override
    public boolean shouldDrawTooltip() {
        return this.drawTooltip;
    }

    @Override
    public RecipeEntry copy() {
        ItemStack[] stacksToCopy = new ItemStack[this.normalAlternatives.length];
        for (int i = 0; i < stacksToCopy.length; ++i) {
            stacksToCopy[i] = this.normalAlternatives[i].func_77946_l();
        }
        return new RecipeEntry(this.stackSize, stacksToCopy, (String[])this.oreDictAlternatives.clone());
    }

    @Override
    public boolean isItemFitting(ItemStack stack) {
        int[] stackOreIds;
        if (!ItemStackUtils.isValid((ItemStack)stack)) {
            return false;
        }
        for (ItemStack nrmStack : this.normalAlternatives) {
            if (!ItemStackUtils.areEqualNbtFit((ItemStack)nrmStack, (ItemStack)stack, (boolean)false, (boolean)true)) continue;
            return true;
        }
        for (int oreId : stackOreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            String oreIdName = OreDictionary.getOreName((int)oreId);
            if (!ArrayUtils.contains((Object[])this.oreDictAlternatives, (Object)oreIdName)) continue;
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack[] getEntryItemStacks() {
        if (this.cachedEntryStacks == null || this.cachedEntryStacks.get() == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<ItemStack> fltStacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : this.normalAlternatives) {
                if (itemStack.func_77952_i() == Short.MAX_VALUE) {
                    itemStack.func_77973_b().func_150895_a(itemStack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                    continue;
                }
                stacks.add(itemStack);
            }
            for (ItemStack itemStack : this.oreDictAlternatives) {
                OreDictionary.getOres((String)itemStack).forEach(stack -> {
                    if (stack.func_77952_i() == Short.MAX_VALUE) {
                        stack.func_77973_b().func_150895_a(stack.func_77973_b(), CreativeTabs.field_78027_g, stacks);
                    } else {
                        stacks.add((ItemStack)stack);
                    }
                });
            }
            for (ItemStack stack3 : stacks) {
                ItemStack valid = stack3.func_77946_l();
                for (ItemStack fltStack : fltStacks) {
                    if (!fltStack.func_77969_a(valid)) continue;
                    valid = null;
                    break;
                }
                if (valid == null) continue;
                valid.field_77994_a = this.stackSize;
                fltStacks.add(valid);
            }
            this.cachedEntryStacks = new WeakReference<ItemStack[]>(fltStacks.toArray(new ItemStack[fltStacks.size()]));
        }
        return (ItemStack[])this.cachedEntryStacks.get();
    }

    @Override
    public int getItemCount() {
        return this.stackSize;
    }

    @Override
    public void decreaseItemCount(int amount) {
        assert (amount <= 0) : "Amount must be greater than 0!";
        assert (this.stackSize - amount < 0) : "Item count cannot become less than 0!";
        this.stackSize -= amount;
    }
}

