/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.assembly;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.assembly.IRecipeEntry;
import de.sanandrew.mods.turretmod.api.assembly.IRecipeGroup;
import de.sanandrew.mods.turretmod.api.assembly.ITurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.block.BlockRegistry;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;

public final class TurretAssemblyRegistry
implements ITurretAssemblyRegistry {
    public static final TurretAssemblyRegistry INSTANCE = new TurretAssemblyRegistry();
    private final Map<UUID, ItemStack> recipeResults = new HashMap<UUID, ItemStack>();
    private final Map<UUID, RecipeEntry> recipeResources = new HashMap<UUID, RecipeEntry>();
    private final List<RecipeKeyEntry> recipeEntries = new ArrayList<RecipeKeyEntry>();
    private final List<IRecipeGroup> groupsList = new ArrayList<IRecipeGroup>();

    @Override
    public boolean registerRecipe(UUID uuid, IRecipeGroup group, ItemStack result, int fluxPerTick, int ticksProcessing, IRecipeEntry ... resources) {
        if (uuid == null) {
            TmrConstants.LOG.log(Level.ERROR, "UUID for assembly recipe cannot be null!", (Throwable)new InvalidParameterException());
            return false;
        }
        if (this.recipeResults.containsKey(uuid)) {
            TmrConstants.LOG.log(Level.ERROR, String.format("UUID %s for assembly recipe cannot be registered twice!", uuid), (Throwable)new InvalidParameterException());
            return false;
        }
        if (!ItemStackUtils.isValid((ItemStack)result)) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Result stack of UUID %s is not valid!", uuid), (Throwable)new InvalidParameterException());
            return false;
        }
        if (fluxPerTick < 0) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Flux usage cannot be smaller than 0 for UUID %s!", uuid), (Throwable)new InvalidParameterException());
            return false;
        }
        if (ticksProcessing < 0) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Ticks processing cannot be smaller than 0 for UUID %s!", uuid), (Throwable)new InvalidParameterException());
            return false;
        }
        if (resources == null) {
            resources = new IRecipeEntry[]{};
        }
        this.recipeResults.put(uuid, result);
        this.recipeResources.put(uuid, new RecipeEntry(resources, fluxPerTick, ticksProcessing));
        this.recipeEntries.add(new RecipeKeyEntry(uuid, result));
        group.addRecipeId(uuid);
        return true;
    }

    @Override
    public IRecipeGroup registerGroup(String name, ItemStack stack) {
        name = BlockRegistry.TURRET_ASSEMBLY.func_149739_a() + '.' + name;
        RecipeGroup group = new RecipeGroup(name, stack);
        this.groupsList.add(group);
        return group;
    }

    @Override
    public IRecipeGroup getGroup(String name) {
        String fullName = BlockRegistry.TURRET_ASSEMBLY.func_149739_a() + '.' + name;
        return this.groupsList.stream().filter(group -> group.getName().equals(fullName)).findFirst().orElse(null);
    }

    public IRecipeGroup[] getGroups() {
        return this.groupsList.toArray(new IRecipeGroup[this.groupsList.size()]);
    }

    public RecipeEntry getRecipeEntry(UUID uuid) {
        return this.recipeResources.get(uuid);
    }

    public RecipeEntry getRecipeEntry(ItemStack result) {
        for (Map.Entry<UUID, ItemStack> entry : this.recipeResults.entrySet()) {
            if (!ItemStackUtils.areEqual((ItemStack)result, (ItemStack)entry.getValue())) continue;
            return this.recipeResources.get(entry.getKey());
        }
        return null;
    }

    @Override
    public ItemStack getRecipeResult(UUID uuid) {
        ItemStack stack = this.recipeResults.get(uuid);
        return stack.func_77946_l();
    }

    @Override
    public List<RecipeKeyEntry> getRecipeList() {
        return new ArrayList<RecipeKeyEntry>(this.recipeEntries);
    }

    public void finalizeRegistry() {
        this.recipeEntries.sort((o1, o2) -> {
            int i = Integer.compare(Item.func_150891_b((Item)o2.stack.func_77973_b()), Item.func_150891_b((Item)o1.stack.func_77973_b()));
            return i;
        });
        this.groupsList.forEach(group -> group.finalizeGroup(this));
    }

    private static int getStackIndexInList(List<ItemStack> stacks, ItemStack stack) {
        return stacks.indexOf(stacks.stream().filter(fltStack -> ItemStackUtils.areEqual((ItemStack)stack, (ItemStack)fltStack)).findFirst().orElse(null));
    }

    public boolean checkAndConsumeResources(IInventory inv, UUID uuid) {
        RecipeEntry entry = this.getRecipeEntry(uuid);
        if (entry == null) {
            return false;
        }
        entry = entry.copy();
        ArrayList<Tuple> resourceOnSlotList = new ArrayList<Tuple>();
        ArrayList<IRecipeEntry> resourceStacks = new ArrayList<IRecipeEntry>(Arrays.asList(entry.resources));
        Iterator resourceStacksIt = resourceStacks.iterator();
        int invSize = inv.func_70302_i_();
        block0: while (resourceStacksIt.hasNext()) {
            IRecipeEntry resource = (IRecipeEntry)resourceStacksIt.next();
            if (resource == null) {
                return false;
            }
            for (int i = invSize - 1; i >= 2; --i) {
                ItemStack invStack = inv.func_70301_a(i);
                if (!ItemStackUtils.isValid((ItemStack)invStack)) continue;
                ItemStack validStack = ItemStackUtils.getEmpty();
                if (resource.isItemFitting(invStack)) {
                    validStack = invStack;
                }
                if (ItemStackUtils.isValid((ItemStack)validStack)) {
                    resourceOnSlotList.add(new Tuple(new Object[]{i, Math.min(validStack.field_77994_a, resource.getItemCount())}));
                    resource.decreaseItemCount(validStack.field_77994_a);
                }
                if (resource.getItemCount() > 0) continue;
                resourceStacksIt.remove();
                continue block0;
            }
        }
        if (resourceStacks.size() > 0) {
            return false;
        }
        for (Tuple resourceSlot : resourceOnSlotList) {
            inv.func_70298_a(((Integer)resourceSlot.getValue(0)).intValue(), ((Integer)resourceSlot.getValue(1)).intValue());
        }
        return true;
    }

    public static class RecipeGroup
    implements IRecipeGroup {
        private final String name;
        private final ItemStack icon;
        private final List<UUID> recipes = new ArrayList<UUID>();

        public RecipeGroup(String name, ItemStack icon) {
            this.name = name;
            this.icon = icon;
        }

        @Override
        public void addRecipeId(UUID id) {
            this.recipes.add(id);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ItemStack getIcon() {
            return this.icon;
        }

        @Override
        public List<UUID> getRecipeIdList() {
            return new ArrayList<UUID>(this.recipes);
        }

        @Override
        public void finalizeGroup(ITurretAssemblyRegistry registry) {
            this.recipes.sort((o1, o2) -> {
                ItemStack is1 = registry.getRecipeResult((UUID)o1);
                ItemStack is2 = registry.getRecipeResult((UUID)o2);
                int i = Integer.compare(Item.func_150891_b((Item)is1.func_77973_b()), Item.func_150891_b((Item)is2.func_77973_b()));
                return i;
            });
        }
    }

    public static class RecipeKeyEntry {
        public final UUID id;
        public final ItemStack stack;

        public RecipeKeyEntry(UUID id, ItemStack stack) {
            this.id = id;
            this.stack = stack;
        }
    }

    public static class RecipeEntry {
        public final IRecipeEntry[] resources;
        public final int fluxPerTick;
        public final int ticksProcessing;

        RecipeEntry(IRecipeEntry[] resources, int fluxPerTick, int ticksProcessing) {
            this.resources = resources;
            this.fluxPerTick = fluxPerTick;
            this.ticksProcessing = ticksProcessing;
        }

        public RecipeEntry copy() {
            ArrayList<de.sanandrew.mods.turretmod.registry.assembly.RecipeEntry> stacks = new ArrayList<de.sanandrew.mods.turretmod.registry.assembly.RecipeEntry>();
            for (IRecipeEntry stack : this.resources) {
                stacks.add(stack.copy());
            }
            return new RecipeEntry(stacks.toArray(new IRecipeEntry[stacks.size()]), this.fluxPerTick, this.ticksProcessing);
        }
    }
}

