/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.electrolytegen;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.registry.electrolytegen.ElectrolyteRegistry;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class ElectrolyteProcess {
    public final ItemStack processStack;
    public final ItemStack trashStack;
    public final ItemStack treasureStack;
    public final short maxProgress;
    public final float effectivenes;
    private short progress;

    public ElectrolyteProcess(ItemStack stack) {
        this.processStack = stack;
        ElectrolyteRegistry.Fuel fuel = ElectrolyteRegistry.getFuel(stack);
        this.progress = 0;
        this.maxProgress = fuel.ticksProc;
        this.effectivenes = fuel.effect;
        this.trashStack = fuel.trash.func_77946_l();
        this.treasureStack = fuel.treasure.func_77946_l();
    }

    public ElectrolyteProcess(ByteBuf buf) {
        this.processStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.progress = buf.readShort();
        this.maxProgress = buf.readShort();
        ElectrolyteRegistry.Fuel fuel = ElectrolyteRegistry.getFuel(this.processStack);
        this.effectivenes = fuel.effect;
        this.trashStack = fuel.trash.func_77946_l();
        this.treasureStack = fuel.treasure.func_77946_l();
    }

    public ElectrolyteProcess(NBTTagCompound nbt) {
        this.processStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("progressItem"));
        this.progress = nbt.func_74765_d("progress");
        this.maxProgress = nbt.func_74765_d("progressMax");
        ElectrolyteRegistry.Fuel fuel = ElectrolyteRegistry.getFuel(this.processStack);
        this.effectivenes = fuel.effect;
        this.trashStack = fuel.trash.func_77946_l();
        this.treasureStack = fuel.treasure.func_77946_l();
    }

    public void writeToByteBuf(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.processStack);
        buf.writeShort((int)this.progress);
        buf.writeShort((int)this.maxProgress);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        ItemStackUtils.writeStackToTag((ItemStack)this.processStack, (NBTTagCompound)nbt, (String)"progressItem");
        nbt.func_74777_a("progress", this.progress);
        nbt.func_74777_a("progressMax", this.progress);
    }

    public boolean hasTrash() {
        return ItemStackUtils.isValid((ItemStack)this.trashStack);
    }

    public boolean hasTreasure() {
        return ItemStackUtils.isValid((ItemStack)this.treasureStack);
    }

    public int getProgress() {
        return this.progress;
    }

    public void incrProgress() {
        this.progress = (short)(this.progress + 1);
    }

    public boolean hasFinished() {
        return this.progress >= this.maxProgress;
    }
}

