/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.repairkit;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.sanlib.lib.util.UuidUtils;
import de.sanandrew.mods.turretmod.api.TmrConstants;
import de.sanandrew.mods.turretmod.api.repairkit.IRepairKitRegistry;
import de.sanandrew.mods.turretmod.api.repairkit.TurretRepairKit;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public final class RepairKitRegistry
implements IRepairKitRegistry {
    public static final RepairKitRegistry INSTANCE = new RepairKitRegistry();
    private final Map<UUID, TurretRepairKit> kitsFromUUID = new HashMap<UUID, TurretRepairKit>();
    private final Map<TurretRepairKit, UUID> uuidFromKits = new HashMap<TurretRepairKit, UUID>();
    private final List<TurretRepairKit> kits = new ArrayList<TurretRepairKit>();
    private static final UUID EMPTY = UuidUtils.EMPTY_UUID;
    private static final TurretRepairKit EMPTY_REPKIT = new TurretRepairKit(){

        @Override
        public String getName() {
            return "EMPTY";
        }

        @Override
        public UUID getUUID() {
            return EMPTY;
        }

        @Override
        public float getHealAmount() {
            return 0.0f;
        }

        @Override
        public boolean isApplicable(ITurretInst turret) {
            return false;
        }

        @Override
        public ResourceLocation getModel() {
            return null;
        }
    };

    private RepairKitRegistry() {
    }

    @Override
    public boolean register(TurretRepairKit type) {
        if (type == null) {
            TmrConstants.LOG.log(Level.ERROR, "Cannot register NULL as Repair Kit!", (Throwable)new InvalidParameterException());
            return false;
        }
        if (type.getName() == null || type.getName().isEmpty()) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Repair Kit %s has an empty/NULL name! Cannot register the Void.", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        if (type.getUUID() == null) {
            TmrConstants.LOG.log(Level.ERROR, String.format("Repair Kit %s has no UUID! How am I supposed to differentiate all the screws?", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        if (this.kitsFromUUID.containsKey(type.getUUID())) {
            TmrConstants.LOG.log(Level.ERROR, String.format("The UUID of the Repair Kit %s is already registered! Use another UUID. JUST DO IT!", type.getName()), (Throwable)new InvalidParameterException());
            return false;
        }
        this.kitsFromUUID.put(type.getUUID(), type);
        this.uuidFromKits.put(type, type.getUUID());
        this.kits.add(type);
        return true;
    }

    @Override
    public List<TurretRepairKit> getRegisteredTypes() {
        return new ArrayList<TurretRepairKit>(this.kits);
    }

    @Override
    public TurretRepairKit getType(UUID uuid) {
        return (TurretRepairKit)MiscUtils.defIfNull((Object)this.kitsFromUUID.get(uuid), (Object)EMPTY_REPKIT);
    }

    @Override
    public UUID getTypeId(TurretRepairKit type) {
        return this.uuidFromKits.get(type);
    }

    @Override
    public TurretRepairKit getType(ItemStack stack) {
        NBTTagCompound nbt;
        if (ItemStackUtils.isItem((ItemStack)stack, (Item)ItemRegistry.REPAIR_KIT) && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b("repKitType")) {
            String typeUUID = nbt.func_74779_i("repKitType");
            try {
                return this.getType(UUID.fromString(typeUUID));
            }
            catch (IllegalArgumentException ex) {
                return EMPTY_REPKIT;
            }
        }
        return EMPTY_REPKIT;
    }
}

