/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInfo;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.Sounds;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public class TurretFlamethrower
implements ITurret {
    public static final ResourceLocation ITEM_MODEL = new ResourceLocation("sapturretmod", "turrets/turret_flamethrower");
    public static final UUID TIII_UUID = UUID.fromString("0C61E401-A5F9-44E9-8B29-3A3DC7762C73");
    private static final AxisAlignedBB RANGE_BB = new AxisAlignedBB(-8.0, -2.0, -8.0, 8.0, 4.0, 8.0);

    @Override
    public void applyEntityAttributes(ITurretInst turretInst) {
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a(1.0);
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_AMMO_CAPACITY).func_111128_a(4096.0);
        turretInst.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return Resources.TURRET_T3_FTHROWER.getResource();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T3_FTHROWER_GLOW.getResource();
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        return RANGE_BB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return turretInst.getEntity().func_70681_au().nextBoolean() ? Sounds.SHOOT_FLAMETHROWER : null;
    }

    @Override
    public String getName() {
        return "iii_flamethrower";
    }

    @Override
    public UUID getId() {
        return TIII_UUID;
    }

    @Override
    public ResourceLocation getItemModel() {
        return ITEM_MODEL;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public ITurretInfo getInfo() {
        return MyInfo.INSTANCE;
    }

    public static final class MyInfo
    implements ITurretInfo {
        static final ITurretInfo INSTANCE = new MyInfo();

        @Override
        public float getHealth() {
            return 40.0f;
        }

        @Override
        public int getAmmoCapacity() {
            return 4096;
        }

        @Override
        public String getRange() {
            return "8";
        }
    }
}

