/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInfo;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.Sounds;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.UUID;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public class TurretMinigun
implements ITurret {
    public static final ResourceLocation ITEM_MODEL = new ResourceLocation("sapturretmod", "turrets/turret_minigun");
    public static final UUID TII_UUID = UUID.fromString("97E1FB65-EE36-43BA-A900-583B4BD7973A");
    private static final AxisAlignedBB RANGE_BB = new AxisAlignedBB(-20.0, -4.0, -20.0, 20.0, 10.0, 20.0);

    @Override
    public void applyEntityAttributes(ITurretInst turretInst) {
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_AMMO_CAPACITY).func_111128_a(512.0);
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a(3.0);
        turretInst.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    public void onUpdate(ITurretInst turretInst) {
        EntityLiving turretL = turretInst.getEntity();
        MyRAM ram = turretInst.getRAM(MyRAM::new);
        ram.prevBarrelLeft = ram.barrelLeft;
        ram.prevBarrelRight = ram.barrelRight;
        ram.barrelLeft = ram.barrelLeft < ram.maxBarrelLeft ? (ram.barrelLeft += 90.0f / (float)turretInst.getTargetProcessor().getMaxShootTicks() * 2.0f) : ram.maxBarrelLeft;
        ram.barrelRight = ram.barrelRight < ram.maxBarrelRight ? (ram.barrelRight += 90.0f / (float)turretInst.getTargetProcessor().getMaxShootTicks() * 2.0f) : ram.maxBarrelRight;
        if (turretInst.wasShooting()) {
            if (ram.isLeftShot) {
                ram.maxBarrelRight += 90.0f;
                ram.isLeftShot = false;
            } else {
                ram.maxBarrelLeft += 90.0f;
                ram.isLeftShot = true;
            }
            if (turretL.field_70170_p.field_72995_K) {
                TurretModRebirth.proxy.spawnParticle(EnumParticle.MINIGUN_SHOT, turretL.field_70165_t, turretL.field_70163_u + 1.5, turretL.field_70161_v, new Tuple(new Object[]{Float.valueOf(turretL.field_70759_as), Float.valueOf(turretL.field_70125_A - 7.5f), turretInst.isUpsideDown(), ram.isLeftShot}));
            }
        }
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return (turretInst.getEntity().func_145818_k_() && turretInst.getEntity().func_95999_t().equalsIgnoreCase("silverchiren") ? Resources.TURRET_T2_MINIGUN_EE : Resources.TURRET_T2_MINIGUN).getResource();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_MINIGUN_GLOW.getResource();
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        return RANGE_BB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return Sounds.SHOOT_MINIGUN;
    }

    @Override
    public String getName() {
        return "ii_minigun";
    }

    @Override
    public UUID getId() {
        return TII_UUID;
    }

    @Override
    public ResourceLocation getItemModel() {
        return ITEM_MODEL;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public ITurretInfo getInfo() {
        return MyInfo.INSTANCE;
    }

    public static final class MyInfo
    implements ITurretInfo {
        static final ITurretInfo INSTANCE = new MyInfo();

        @Override
        public float getHealth() {
            return 30.0f;
        }

        @Override
        public int getAmmoCapacity() {
            return 512;
        }

        @Override
        public String getRange() {
            return "20";
        }
    }

    public static final class MyRAM
    implements ITurretRAM {
        public float barrelLeft = 0.0f;
        public float barrelRight = 0.0f;
        public float prevBarrelLeft = 0.0f;
        public float prevBarrelRight = 0.0f;
        public float maxBarrelLeft = 0.0f;
        public float maxBarrelRight = 0.0f;
        public boolean isLeftShot = false;
    }
}

