/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInfo;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.Sounds;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.UUID;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public class TurretRevolver
implements ITurret {
    public static final ResourceLocation ITEM_MODEL = new ResourceLocation("sapturretmod", "turrets/turret_revolver");
    public static final UUID TII_UUID = UUID.fromString("4449D836-F122-409A-8E6C-D7B7438FD08C");
    private static final AxisAlignedBB RANGE_BB = new AxisAlignedBB(-20.0, -4.0, -20.0, 20.0, 10.0, 20.0);

    @Override
    public void applyEntityAttributes(ITurretInst turretInst) {
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a(15.0);
        turretInst.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    public void onUpdate(ITurretInst turretInst) {
        EntityLiving turretL = turretInst.getEntity();
        MyRAM ram = turretInst.getRAM(MyRAM::new);
        ram.prevBarrelLeft = ram.barrelLeft;
        ram.prevBarrelRight = ram.barrelRight;
        ram.barrelLeft = ram.barrelLeft < 1.0f ? (ram.barrelLeft += 1.1999999f / (float)turretInst.getTargetProcessor().getMaxShootTicks()) : 1.0f;
        ram.barrelRight = ram.barrelRight < 1.0f ? (ram.barrelRight += 1.1999999f / (float)turretInst.getTargetProcessor().getMaxShootTicks()) : 1.0f;
        if (turretInst.wasShooting()) {
            float partShift;
            if (ram.isLeftShot) {
                ram.barrelRight = 0.0f;
                ram.isLeftShot = false;
                partShift = 10.0f;
            } else {
                ram.barrelLeft = 0.0f;
                ram.isLeftShot = true;
                partShift = -10.0f;
            }
            if (turretL.field_70170_p.field_72995_K) {
                TurretModRebirth.proxy.spawnParticle(EnumParticle.SHOTGUN_SHOT, turretL.field_70165_t, turretL.field_70163_u + 1.5, turretL.field_70161_v, new Tuple(new Object[]{Float.valueOf(turretL.field_70759_as + partShift), Float.valueOf(turretL.field_70125_A), turretInst.isUpsideDown()}));
            }
        }
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_REVOLVER.getResource();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T2_REVOLVER_GLOW.getResource();
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        return RANGE_BB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return Sounds.SHOOT_REVOLVER;
    }

    @Override
    public String getName() {
        return "ii_revolver";
    }

    @Override
    public UUID getId() {
        return TII_UUID;
    }

    @Override
    public ResourceLocation getItemModel() {
        return ITEM_MODEL;
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public ITurretInfo getInfo() {
        return MyInfo.INSTANCE;
    }

    public static final class MyInfo
    implements ITurretInfo {
        static final ITurretInfo INSTANCE = new MyInfo();

        @Override
        public float getHealth() {
            return 30.0f;
        }

        @Override
        public int getAmmoCapacity() {
            return 256;
        }

        @Override
        public String getRange() {
            return "20";
        }
    }

    public static class MyRAM
    implements ITurretRAM {
        public float barrelLeft = 1.0f;
        public float barrelRight = 1.0f;
        public float prevBarrelLeft = 1.0f;
        public float prevBarrelRight = 1.0f;
        public boolean isLeftShot = false;
    }
}

