/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInfo;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.util.EnumParticle;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.Sounds;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.UUID;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public class TurretShotgun
implements ITurret {
    public static final ResourceLocation ITEM_MODEL = new ResourceLocation("sapturretmod", "turrets/turret_shotgun");
    public static final UUID TI_UUID = UUID.fromString("F7991EC5-2A89-49A6-B8EA-80775973C4C5");
    private static final AxisAlignedBB RANGE_BB = new AxisAlignedBB(-16.0, -4.0, -16.0, 16.0, 8.0, 16.0);

    @Override
    public void applyEntityAttributes(ITurretInst turretInst) {
        turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111128_a(20.0);
    }

    @Override
    public void onUpdate(ITurretInst turretInst) {
        EntityLiving turretL = turretInst.getEntity();
        if (turretL.field_70170_p.field_72995_K) {
            MyRAM ram = turretInst.getRAM(MyRAM::new);
            ram.prevBarrelPos = ram.barrelPos;
            ram.barrelPos = ram.barrelPos < 1.0f ? (ram.barrelPos += 1.1999999f / (float)turretInst.getTargetProcessor().getMaxShootTicks()) : 1.0f;
            if (turretInst.wasShooting()) {
                ram.barrelPos = 0.0f;
                TurretModRebirth.proxy.spawnParticle(EnumParticle.SHOTGUN_SHOT, turretL.field_70165_t, turretL.field_70163_u + 1.5, turretL.field_70161_v, new Tuple(new Object[]{Float.valueOf(turretL.field_70759_as), Float.valueOf(turretL.field_70125_A), turretInst.isUpsideDown()}));
            }
        }
    }

    @Override
    public ResourceLocation getStandardTexture(ITurretInst turretInst) {
        return Resources.TURRET_T1_SHOTGUN.getResource();
    }

    @Override
    public ResourceLocation getGlowTexture(ITurretInst turretInst) {
        return Resources.TURRET_T1_SHOTGUN_GLOW.getResource();
    }

    @Override
    public AxisAlignedBB getRangeBB(ITurretInst turretInst) {
        return RANGE_BB;
    }

    @Override
    public SoundEvent getShootSound(ITurretInst turretInst) {
        return Sounds.SHOOT_SHOTGUN;
    }

    @Override
    public String getName() {
        return "i_shotgun";
    }

    @Override
    public UUID getId() {
        return TI_UUID;
    }

    @Override
    public ResourceLocation getItemModel() {
        return ITEM_MODEL;
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public ITurretInfo getInfo() {
        return MyInfo.INSTANCE;
    }

    public static final class MyInfo
    implements ITurretInfo {
        static final ITurretInfo INSTANCE = new MyInfo();

        @Override
        public float getHealth() {
            return 20.0f;
        }

        @Override
        public int getAmmoCapacity() {
            return 256;
        }

        @Override
        public String getRange() {
            return "16";
        }
    }

    public static class MyRAM
    implements ITurretRAM {
        public float barrelPos = 1.0f;
        public float prevBarrelPos = 1.0f;
    }
}

