/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.shieldgen;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretRAM;
import de.sanandrew.mods.turretmod.api.turret.IUpgradeProcessor;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldTurretRecovery;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.util.TmrUtils;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public final class ShieldTurret
implements ITurretRAM,
IForcefieldProvider {
    static final ColorObj BASE_COLOR = new ColorObj(0x40FFFFFF);
    static final ColorObj CRIT_COLOR = new ColorObj(0x40FF0000);
    static final float[] BASE_CLR_HSL = BASE_COLOR.calcHSL();
    static final float[] CRIT_CLR_HSL = CRIT_COLOR.calcHSL();
    static final float[] HSL_DIF = new float[]{TmrUtils.wrap360(BASE_CLR_HSL[0] - CRIT_CLR_HSL[0]), BASE_CLR_HSL[1] - CRIT_CLR_HSL[1], BASE_CLR_HSL[2] - CRIT_CLR_HSL[2]};
    static final float RECOVERY_PER_TICK = 5.0E-4f;
    static final float MAX_VALUE_RECOVERED = 100.0f;
    float value;
    float recovery;
    final ITurretInst turretInst;

    public ShieldTurret(ITurretInst turretInst) {
        this.turretInst = turretInst;
        this.value = 0.0f;
        this.recovery = 0.0f;
    }

    public void damage(float dmg) {
        if (dmg <= 0.0f) {
            return;
        }
        if (this.value < dmg) {
            this.value = 0.0f;
            return;
        }
        this.value -= dmg;
    }

    public float getMaxValue() {
        IUpgradeProcessor upgProc = this.turretInst.getUpgradeProcessor();
        return upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_II) ? 250.0f : (upgProc.hasUpgrade(Upgrades.SHIELD_STRENGTH_I) ? 150.0f : 100.0f);
    }

    public float getCritValue() {
        return this.getMaxValue() / 10.0f;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isInRecovery() {
        return this.recovery > 0.0f && this.turretInst.isActive();
    }

    public float getRecovery() {
        return this.recovery;
    }

    @Override
    public boolean isShieldActive() {
        return this.value > 0.0f && this.turretInst.isActive();
    }

    @Override
    public AxisAlignedBB getShieldBoundingBox() {
        return this.turretInst.getRangeBB();
    }

    @Override
    public int getShieldColor() {
        float critVal = this.getCritValue();
        if (this.value < critVal) {
            return ShieldTurret.getCritColor(this.value / critVal);
        }
        return BASE_COLOR.getColorInt();
    }

    public void onTick() {
        float maxVal = this.getMaxValue();
        if (this.turretInst.isActive() && this.turretInst.getTargetProcessor().hasAmmo() && this.value < maxVal) {
            double speedMulti = this.turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS).func_111126_e();
            if (this.value <= 0.0f) {
                int prevRecoveryPerc = MathHelper.func_76141_d((float)(this.recovery * 100.0f));
                this.recovery = (float)((double)this.recovery + (double)5.0E-4f * (2.0 - speedMulti));
                if (prevRecoveryPerc != MathHelper.func_76141_d((float)(this.recovery * 100.0f))) {
                    this.turretInst.getTargetProcessor().decrAmmo();
                }
            } else if ((long)this.turretInst.getEntity().field_70173_aa % Math.round(40.0 * speedMulti) == 0L) {
                this.value += 1.0f;
                if (this.value > maxVal) {
                    this.value = maxVal;
                }
                this.turretInst.getTargetProcessor().decrAmmo();
            }
        }
        if (this.recovery >= 1.0f) {
            this.value = 100.0f;
            this.recovery = 0.0f;
        }
        if (this.value > maxVal) {
            this.value = maxVal;
        }
        if (this.turretInst.getEntity().field_70170_p.field_72995_K) {
            if (this.isInRecovery() && !TmrUtils.INSTANCE.hasForcefield((Entity)this.turretInst.getEntity(), ShieldTurretRecovery.class)) {
                TmrUtils.INSTANCE.addForcefield((Entity)this.turretInst.getEntity(), new ShieldTurretRecovery(this));
            }
            if (this.isShieldActive() && !TmrUtils.INSTANCE.hasForcefield((Entity)this.turretInst.getEntity(), this.getClass())) {
                TmrUtils.INSTANCE.addForcefield((Entity)this.turretInst.getEntity(), this);
            }
        }
    }

    static int getCritColor(float relation) {
        float alpha = CRIT_COLOR.fAlpha() + (BASE_COLOR.fAlpha() - CRIT_COLOR.fAlpha()) * relation;
        float[] hslDif = (float[])HSL_DIF.clone();
        hslDif[0] = TmrUtils.wrap360(CRIT_CLR_HSL[0] + (hslDif[0] > 180.0f ? -(360.0f - hslDif[0]) : hslDif[0]) * relation);
        hslDif[1] = CRIT_CLR_HSL[1] + hslDif[1] * relation;
        hslDif[2] = CRIT_CLR_HSL[2] + hslDif[2] * relation;
        return ColorObj.fromHSLA((float)hslDif[0], (float)hslDif[1], (float)hslDif[2], (float)alpha).getColorInt();
    }
}

