/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.turret.shieldgen;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.registry.turret.shieldgen.ShieldTurret;
import net.minecraft.util.math.AxisAlignedBB;

public final class ShieldTurretRecovery
implements IForcefieldProvider {
    final ShieldTurret delegate;

    ShieldTurretRecovery(ShieldTurret delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isShieldActive() {
        return this.delegate.isInRecovery() && this.delegate.turretInst.isActive();
    }

    @Override
    public AxisAlignedBB getShieldBoundingBox() {
        return this.delegate.getShieldBoundingBox();
    }

    @Override
    public int getShieldColor() {
        float perc = this.delegate.recovery;
        if (perc < 0.9f) {
            ColorObj newClr = new ColorObj(ShieldTurret.CRIT_COLOR);
            newClr.setAlpha(Math.round(ShieldTurret.CRIT_COLOR.fAlpha() * 255.0f * (perc /= 0.9f)));
            return newClr.getColorInt();
        }
        return ShieldTurret.getCritColor((perc - 0.9f) * 10.0f);
    }

    @Override
    public boolean hasSmoothFadeOut() {
        return false;
    }

    @Override
    public boolean renderFull() {
        return true;
    }
}

