/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.ResourceLocation;

public abstract class UpgradeHealth
implements ITurretUpgrade {
    private final ResourceLocation itemModel;
    private final String name;
    private final AttributeModifier modifier;

    public UpgradeHealth(String name, String modUUID) {
        this.name = name;
        this.modifier = new AttributeModifier(UUID.fromString(modUUID), String.format("%s:%s", "sapturretmod", name), 0.25, 1);
        this.itemModel = new ResourceLocation("sapturretmod", "upgrades/" + name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }

    @Override
    public boolean isTurretApplicable(ITurret turret) {
        return true;
    }

    @Override
    public void onApply(ITurretInst turretInst) {
        if (!turretInst.getEntity().field_70170_p.field_72995_K) {
            IAttributeInstance attrib = turretInst.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (attrib.func_111127_a(this.modifier.func_111167_a()) != null) {
                attrib.func_111124_b(this.modifier);
            }
            attrib.func_111121_a(this.modifier);
        }
    }

    @Override
    public void onRemove(ITurretInst turretInst) {
        IAttributeInstance attrib;
        if (!turretInst.getEntity().field_70170_p.field_72995_K && (attrib = turretInst.getEntity().func_110148_a(SharedMonsterAttributes.field_111267_a)).func_111127_a(this.modifier.func_111167_a()) != null) {
            attrib.func_111124_b(this.modifier);
            turretInst.getEntity().func_70606_j(turretInst.getEntity().func_110143_aJ());
        }
    }

    public static class UpgradeHealthMK4
    extends UpgradeHealth {
        private final ITurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(Upgrades.HEALTH_III);

        public UpgradeHealthMK4() {
            super("health_iv", "9431A60C-B995-4547-B143-2BEDC67467E1");
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return this.dependant;
        }

        @Override
        public boolean isTurretApplicable(ITurret turret) {
            return turret.getTier() < 4;
        }
    }

    public static class UpgradeHealthMK3
    extends UpgradeHealth {
        private final ITurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(Upgrades.HEALTH_II);

        public UpgradeHealthMK3() {
            super("health_iii", "D49F43AE-5EA4-4DD2-B08A-9B5F1966C091");
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return this.dependant;
        }
    }

    public static class UpgradeHealthMK2
    extends UpgradeHealth {
        private final ITurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(Upgrades.HEALTH_I);

        public UpgradeHealthMK2() {
            super("health_ii", "B7E5ADFA-517C-4167-A2FD-E0D31FA6E9BE");
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return this.dependant;
        }
    }

    public static class UpgradeHealthMK1
    extends UpgradeHealth {
        public UpgradeHealthMK1() {
            super("health_i", "673176FC-51F9-4CBC-BA12-5073B6867644");
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return null;
        }
    }
}

