/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.registry.upgrades;

import de.sanandrew.mods.turretmod.api.turret.ITurret;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.api.turret.TurretAttributes;
import de.sanandrew.mods.turretmod.api.upgrade.ITurretUpgrade;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.ResourceLocation;

public abstract class UpgradeReloadTime
implements ITurretUpgrade {
    private final ResourceLocation itemModel;
    private final String name;
    private final AttributeModifier modifier;

    public UpgradeReloadTime(String name, String modUUID, double value) {
        this.name = name;
        this.modifier = new AttributeModifier(UUID.fromString(modUUID), String.format("%s:%s", "sapturretmod", name), value, 1);
        this.itemModel = new ResourceLocation("sapturretmod", "upgrades/" + name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceLocation getModel() {
        return this.itemModel;
    }

    @Override
    public boolean isTurretApplicable(ITurret turret) {
        return true;
    }

    @Override
    public void onApply(ITurretInst turretInst) {
        if (!turretInst.getEntity().field_70170_p.field_72995_K) {
            IAttributeInstance attrib = turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS);
            if (attrib.func_111127_a(this.modifier.func_111167_a()) != null) {
                attrib.func_111124_b(this.modifier);
            }
            attrib.func_111121_a(this.modifier);
        }
    }

    @Override
    public void onRemove(ITurretInst turretInst) {
        IAttributeInstance attrib;
        if (!turretInst.getEntity().field_70170_p.field_72995_K && (attrib = turretInst.getEntity().func_110148_a(TurretAttributes.MAX_RELOAD_TICKS)).func_111127_a(this.modifier.func_111167_a()) != null) {
            attrib.func_111124_b(this.modifier);
            turretInst.getEntity().func_70606_j(turretInst.getEntity().func_110143_aJ());
        }
    }

    public static class UpgradeReloadTimeMK2
    extends UpgradeReloadTime {
        private final ITurretUpgrade dependant = UpgradeRegistry.INSTANCE.getUpgrade(Upgrades.RELOAD_I);

        public UpgradeReloadTimeMK2() {
            super("reload_ii", "BA6FE867-0EBF-4E1A-9ED9-05E2B47143F8", -0.35);
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return this.dependant;
        }
    }

    public static class UpgradeReloadTimeMK1
    extends UpgradeReloadTime {
        public UpgradeReloadTimeMK1() {
            super("reload_i", "E6DAE7D4-A730-4F57-B3F9-61C369033625", -0.15);
        }

        @Override
        public ITurretUpgrade getDependantOn() {
            return null;
        }
    }
}

