/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.tileentity.electrolytegen;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

final class ElectrolyteEnergyStorage
implements IEnergyStorage,
INBTSerializable<NBTTagCompound> {
    int fluxAmount;
    int prevFluxAmount;
    int fluxExtractPerTick;
    int fluxBuffer;

    ElectrolyteEnergyStorage() {
    }

    void resetFluxExtract() {
        this.fluxExtractPerTick = Math.min(this.fluxAmount, 1000);
    }

    void updatePrevFlux() {
        this.prevFluxAmount = this.fluxAmount;
    }

    boolean hasFluxChanged() {
        return this.fluxAmount != this.prevFluxAmount;
    }

    void emptyBuffer() {
        if (this.fluxBuffer > 0) {
            int fluxSubtracted = Math.min(500000 - this.fluxAmount, Math.min(200, this.fluxBuffer));
            this.fluxBuffer -= fluxSubtracted;
            this.fluxAmount += fluxSubtracted;
        }
    }

    void fillBuffer(int amount) {
        this.fluxBuffer += amount;
    }

    boolean isBufferEmpty() {
        return this.fluxBuffer <= 200;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int energyExtracted = Math.min(this.fluxExtractPerTick, Math.min(1000, maxExtract));
        if (!simulate) {
            this.fluxAmount -= energyExtracted;
            this.fluxExtractPerTick -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.fluxAmount;
    }

    public int getMaxEnergyStored() {
        return 500000;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("fluxAmount", this.fluxAmount);
        nbt.func_74768_a("fluxBuffer", this.fluxBuffer);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.fluxAmount = nbt.func_74762_e("fluxAmount");
        this.fluxBuffer = nbt.func_74762_e("fluxBuffer");
    }
}

