/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.api.turret;

import de.sanandrew.mods.turretmod.api.turret.ITurretInfo;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;

public interface ITurret {
    public String getName();

    @Nonnull
    public UUID getId();

    public ResourceLocation getItemModel();

    default public void entityInit(ITurretInst turretInst) {
    }

    default public void applyEntityAttributes(ITurretInst turretInst) {
    }

    public ResourceLocation getStandardTexture(ITurretInst var1);

    public ResourceLocation getGlowTexture(ITurretInst var1);

    public SoundEvent getShootSound(ITurretInst var1);

    public AxisAlignedBB getRangeBB(ITurretInst var1);

    public int getTier();

    public ITurretInfo getInfo();

    default public void onUpdate(ITurretInst turretInst) {
    }

    default public void writeSpawnData(ITurretInst turretInst, ByteBuf buf) {
    }

    default public void readSpawnData(ITurretInst turretInst, ByteBuf buf) {
    }

    default public void writeSyncData(ITurretInst turretInst, ObjectOutputStream stream) throws IOException {
    }

    default public void readSyncData(ITurretInst turretInst, ObjectInputStream stream) throws IOException {
    }

    default public void onSave(ITurretInst turretInst, NBTTagCompound nbt) {
    }

    default public void onLoad(ITurretInst turretInst, NBTTagCompound nbt) {
    }

    default public float getDeactiveHeadPitch() {
        return 30.0f;
    }

    default public boolean canSeeThroughBlocks() {
        return false;
    }

    default public SoundEvent getHurtSound(ITurretInst turretInst) {
        return null;
    }

    default public SoundEvent getDeathSound(ITurretInst turretInst) {
        return null;
    }

    default public SoundEvent getNoAmmoSound(ITurretInst turretInst) {
        return null;
    }

    default public SoundEvent getCollectSound(ITurretInst turretInst) {
        return null;
    }
}

