/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.block;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import de.sanandrew.mods.turretmod.util.TmrCreativeTabs;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockTurretAssembly
extends BlockHorizontal {
    BlockTurretAssembly() {
        super(Material.field_151576_e);
        this.func_149647_a(TmrCreativeTabs.MISC);
        this.func_149711_c(4.25f);
        this.field_149762_H = SoundType.field_185851_d;
        this.func_149663_c("sapturretmod:turret_assembly");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.setRegistryName("sapturretmod", "turret_assembly");
    }

    private static void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState northState = world.func_180495_p(pos.func_177978_c());
            IBlockState southState = world.func_180495_p(pos.func_177968_d());
            IBlockState westState = world.func_180495_p(pos.func_177976_e());
            IBlockState eastState = world.func_180495_p(pos.func_177974_f());
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
            if (facing == EnumFacing.NORTH && northState.func_185913_b() && !southState.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && southState.func_185913_b() && !northState.func_185913_b()) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.WEST && westState.func_185913_b() && !eastState.func_185913_b()) {
                facing = EnumFacing.EAST;
            } else if (facing == EnumFacing.EAST && eastState.func_185913_b() && !westState.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_185512_D, (Comparable)facing), 2);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        BlockTurretAssembly.setDefaultFacing(worldIn, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityTurretAssembly assembly = (TileEntityTurretAssembly)world.func_175625_s(pos);
        if (assembly != null) {
            for (int i = 0; i < assembly.getInventory().func_70302_i_(); ++i) {
                ItemStack stack = assembly.getInventory().func_70301_a(i);
                if (!ItemStackUtils.isValid((ItemStack)stack)) continue;
                float xOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
                float yOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
                float zOff = MiscUtils.RNG.randomFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + xOff), (double)((float)pos.func_177956_o() + yOff), (double)((float)pos.func_177952_p() + zOff), stack.func_77946_l());
                float motionSpeed = 0.05f;
                entityitem.field_70159_w = (float)MiscUtils.RNG.randomGaussian() * motionSpeed;
                entityitem.field_70181_x = (float)MiscUtils.RNG.randomGaussian() * motionSpeed + 0.2f;
                entityitem.field_70179_y = (float)MiscUtils.RNG.randomGaussian() * motionSpeed;
                world.func_72838_d((Entity)entityitem);
            }
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TurretModRebirth.proxy.openGui(player, EnumGui.GUI_TASSEMBLY_MAN, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, @Nonnull ItemStack stack) {
        TileEntity tileentity;
        world.func_180501_a(pos, state.func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof TileEntityTurretAssembly) {
            ((TileEntityTurretAssembly)tileentity).setCustomName(stack.func_82833_r());
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new MyBlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTurretAssembly();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public EnumFacing getDirection(int meta) {
        return (EnumFacing)this.func_176203_a(meta).func_177229_b((IProperty)field_185512_D);
    }

    private static final class MyStateImplementation
    extends BlockStateContainer.StateImplementation {
        protected MyStateImplementation(Block blockIn, ImmutableMap<IProperty<?>, Comparable<?>> propertiesIn) {
            super(blockIn, propertiesIn);
        }

        public boolean func_185917_h() {
            return false;
        }

        public EnumBlockRenderType func_185901_i() {
            return EnumBlockRenderType.MODEL;
        }

        public boolean func_185912_n() {
            return true;
        }

        public int func_185888_a(World worldIn, BlockPos pos) {
            return Container.func_94526_b((IInventory)((IInventory)worldIn.func_175625_s(pos)));
        }

        public boolean func_185914_p() {
            return false;
        }
    }

    private static final class MyBlockStateContainer
    extends BlockStateContainer {
        public MyBlockStateContainer(Block blockIn, IProperty<?> ... properties) {
            super(blockIn, properties);
        }

        protected BlockStateContainer.StateImplementation createState(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
            return new MyStateImplementation(block, properties);
        }
    }
}

