/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.event;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.turret.IForcefieldProvider;
import de.sanandrew.mods.turretmod.client.render.ForcefieldCube;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.TmrConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class RenderForcefieldHandler {
    public static final RenderForcefieldHandler INSTANCE = new RenderForcefieldHandler();
    private static final Queue<IForcefieldProvider> EMPTY_QUEUE = new Queue<IForcefieldProvider>(){

        @Override
        public boolean add(IForcefieldProvider provider) {
            return false;
        }

        @Override
        public boolean offer(IForcefieldProvider provider) {
            return false;
        }

        @Override
        public IForcefieldProvider remove() {
            return null;
        }

        @Override
        public IForcefieldProvider poll() {
            return null;
        }

        @Override
        public IForcefieldProvider element() {
            return null;
        }

        @Override
        public IForcefieldProvider peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public Iterator<IForcefieldProvider> iterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends IForcefieldProvider> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
        }
    };
    private final List<ForcefieldCube> fadeOutFields = new ArrayList<ForcefieldCube>();
    private final Map<Integer, Queue<IForcefieldProvider>> fieldProviders = new ConcurrentHashMap<Integer, Queue<IForcefieldProvider>>();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderEntity = mc.func_175606_aa();
        if (renderEntity == null) {
            return;
        }
        float partialTicks = event.getPartialTicks();
        double renderX = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)partialTicks;
        double renderY = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)partialTicks;
        double renderZ = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)partialTicks;
        ArrayList<ForcefieldCube> cubes = new ArrayList<ForcefieldCube>();
        int worldTicks = (int)(mc.field_71441_e.func_82737_E() % Integer.MAX_VALUE);
        Iterator<Map.Entry<Integer, Queue<IForcefieldProvider>>> it = this.fieldProviders.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Queue<IForcefieldProvider>> entry = it.next();
            Entity entity = mc.field_71441_e.func_73045_a(entry.getKey().intValue());
            if (entity == null || entry.getValue().size() < 1) {
                it.remove();
                continue;
            }
            Iterator itFF = entry.getValue().iterator();
            while (itFF.hasNext()) {
                IForcefieldProvider ffProvider = (IForcefieldProvider)itFF.next();
                ColorObj color = new ColorObj(ffProvider.getShieldColor());
                double entityX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
                double entityY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
                double entityZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
                ForcefieldCube cube = new ForcefieldCube(new Vec3d(entityX - renderX, entityY - renderY, entityZ - renderZ), ffProvider.getShieldBoundingBox(), color);
                cube.fullRendered = ffProvider.renderFull();
                if (entity.field_70128_L || !entity.func_70089_S() || !ffProvider.isShieldActive() || !mc.field_71441_e.field_72996_f.contains(entity)) {
                    if (ffProvider.hasSmoothFadeOut()) {
                        this.fadeOutFields.add(cube);
                    }
                    itFF.remove();
                    continue;
                }
                if (TmrConfiguration.calcForcefieldIntf) {
                    for (ForcefieldCube intfCube : cubes) {
                        cube.interfere(intfCube, false);
                        intfCube.interfere(cube, true);
                    }
                }
                cubes.add(cube);
            }
        }
        Iterator<ForcefieldCube> fadeOutIt = this.fadeOutFields.iterator();
        while (fadeOutIt.hasNext()) {
            ForcefieldCube shield = fadeOutIt.next();
            if (shield.boxColor.alpha() <= 0) {
                fadeOutIt.remove();
                continue;
            }
            cubes.add(shield);
            shield.boxColor.setAlpha(shield.boxColor.alpha() - 3);
        }
        Tessellator tess = Tessellator.func_178181_a();
        for (int pass = 1; pass <= 5; ++pass) {
            float transformTexAmount = (float)(worldTicks % 400) + event.getPartialTicks();
            float texTranslateX = 0.0f;
            float texTranslateY = 0.0f;
            switch (pass) {
                case 1: {
                    texTranslateX = transformTexAmount * -0.01f;
                    texTranslateY = transformTexAmount * 0.01f;
                    mc.field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P1.getResource());
                    break;
                }
                case 2: {
                    texTranslateX = transformTexAmount * 0.005f;
                    texTranslateY = transformTexAmount * 0.005f;
                    mc.field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P2.getResource());
                    break;
                }
                case 3: {
                    texTranslateX = transformTexAmount * -0.005f;
                    texTranslateY = transformTexAmount * 0.005f;
                    mc.field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P1.getResource());
                    break;
                }
                case 4: {
                    texTranslateX = transformTexAmount * 0.0025f;
                    texTranslateY = transformTexAmount * 0.0025f;
                    mc.field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P2.getResource());
                    break;
                }
                case 5: {
                    texTranslateX = transformTexAmount * 0.0f;
                    texTranslateY = transformTexAmount * 0.0f;
                    mc.field_71446_o.func_110577_a(Resources.TURRET_FORCEFIELD_P3.getResource());
                }
            }
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)texTranslateX, (float)texTranslateY, (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
            for (ForcefieldCube cube : cubes) {
                tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
                cube.draw(tess);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(cube.boxColor.fAlpha() * 0.5f));
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179129_p();
                tess.func_78381_a();
                GlStateManager.func_179089_o();
                GlStateManager.func_179132_a((boolean)true);
                GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179084_k();
            GlStateManager.func_179128_n((int)5890);
            GL11.glLoadIdentity();
            GlStateManager.func_179128_n((int)5888);
        }
    }

    public void addForcefieldRenderer(Entity entity, IForcefieldProvider provider) {
        Queue fields = this.fieldProviders.computeIfAbsent(entity.func_145782_y(), key -> new ConcurrentLinkedQueue());
        if (fields.stream().noneMatch(prov -> prov.getClass().equals(provider.getClass()))) {
            fields.add(provider);
        }
    }

    public boolean hasForcefield(Entity entity, Class<? extends IForcefieldProvider> providerCls) {
        return this.fieldProviders.getOrDefault(entity.func_145782_y(), EMPTY_QUEUE).stream().anyMatch(prov -> prov.getClass().equals(providerCls));
    }
}

