/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu;

import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.EnumGui;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.turret.IGuiTcuRegistry;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.gui.control.GuiButtonIcon;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.GuiButtonTcuTab;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.GuiInfo;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.GuiSmartTargets;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.GuiTargetCreatures;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.GuiTargetPlayers;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.GuiUpgrades;
import de.sanandrew.mods.turretmod.client.gui.tcu.page.PlayerHeads;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.turret.GuiTcuRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.Upgrades;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import de.sanandrew.mods.turretmod.util.TurretModRebirth;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class GuiTcuHelper {
    private static final int MAX_TABS = 5;
    static final int X_SIZE = 176;
    static final int Y_SIZE = 236;
    final Map<GuiButton, ResourceLocation> tabs = new TreeMap<GuiButton, ResourceLocation>(new ComparatorTabButton());
    GuiButton tabNavLeft;
    GuiButton tabNavRight;
    private static int currTabScroll = 0;
    private long marqueeTime;

    GuiTcuHelper() {
    }

    void initGui(IGuiTcuInst<?> gui) {
        this.tabs.clear();
        MutableInt currIndex = new MutableInt(0);
        GuiTcuRegistry.GUI_RESOURCES.forEach(location -> {
            GuiTcuRegistry.GuiEntry entry = GuiTcuRegistry.INSTANCE.getGuiEntry((ResourceLocation)location);
            if (entry != null && entry.showTab(gui)) {
                GuiButtonTcuTab btn = new GuiButtonTcuTab(gui.getNewButtonId(), 0, gui.getPosY() + 213, entry.getIcon(), Lang.translate(Lang.TCU_PAGE_TITLE.get(location.func_110624_b(), location.func_110623_a()), new Object[0]));
                btn.field_146125_m = false;
                boolean bl = btn.field_146124_l = !location.equals((Object)gui.getRegistryKey());
                if (btn.field_146124_l && (currIndex.getValue() < currTabScroll || currIndex.getValue() >= currTabScroll + 5)) {
                    currTabScroll = Math.min(Math.max(currIndex.getValue() - MathHelper.func_76141_d((float)2.5f), 0), this.tabs.size() - 5 + 1);
                }
                gui.addNewButton(btn);
                this.tabs.put(btn, (ResourceLocation)location);
                currIndex.increment();
            }
        });
        this.tabNavLeft = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), 0, gui.getPosY() + 213, 18, 0, Resources.GUI_TCU_BUTTONS.getResource(), ""));
        this.tabNavLeft.field_146125_m = false;
        this.tabNavRight = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), 0, gui.getPosY() + 213, 36, 0, Resources.GUI_TCU_BUTTONS.getResource(), ""));
        this.tabNavRight.field_146125_m = false;
    }

    boolean hasPermission(Minecraft mc, ITurretInst turretInst) {
        return ItemStackUtils.isItem((ItemStack)mc.field_71439_g.func_184614_ca(), (Item)ItemRegistry.TURRET_CONTROL_UNIT) && turretInst.hasPlayerPermission((EntityPlayer)mc.field_71439_g);
    }

    void updateScreen(Minecraft mc, IGuiTcuInst<?> gui) {
        if (!gui.hasPermision() || gui.getTurretInst().getEntity().field_70128_L || gui.getTurretInst().getEntity().func_70068_e((Entity)mc.field_71439_g) > 36.0) {
            mc.field_71439_g.func_71053_j();
        }
        int maxTabs = Math.min(this.tabs.size(), 5);
        int minXTabs = gui.getPosX() + (gui.getWidth() - maxTabs * 19 + 1) / 2;
        MutableInt currIndex = new MutableInt(0);
        this.tabs.forEach((btn, location) -> {
            int cInd = currIndex.getValue();
            currIndex.increment();
            btn.field_146125_m = cInd >= currTabScroll && cInd < currTabScroll + 5;
            btn.field_146124_l = !gui.getRegistryKey().equals(location);
            btn.field_146128_h = minXTabs + (cInd - currTabScroll) * 19;
        });
        this.tabNavLeft.field_146128_h = minXTabs - 19;
        this.tabNavRight.field_146128_h = minXTabs + maxTabs * 19;
        this.tabNavLeft.field_146125_m = currTabScroll > 0;
        this.tabNavRight.field_146125_m = currTabScroll + 5 < this.tabs.size();
    }

    void drawScreen(IGuiTcuInst<?> gui) {
        FontRenderer fRender = gui.getFontRenderer();
        fRender.func_78276_b(Lang.translate(Lang.TCU_PAGE_TITLE.get(gui.getRegistryKey().func_110624_b(), gui.getRegistryKey().func_110623_a()), new Object[0]), 8, 28, -12566464);
        String turretName = Lang.translate(Lang.TURRET_NAME.get(gui.getTurretInst().getTurret().getName()), new Object[0]);
        int strWidth = fRender.func_78256_a(turretName);
        if (strWidth > 144) {
            int marquee;
            long currTime = System.currentTimeMillis();
            if (this.marqueeTime < 1L) {
                this.marqueeTime = currTime;
            }
            if ((marquee = -144 + (int)(currTime - this.marqueeTime) / 25) > strWidth) {
                this.marqueeTime = currTime;
            }
            GL11.glEnable((int)3089);
            GuiUtils.glScissor((int)(gui.getPosX() + 16), (int)(gui.getPosY() + 6), (int)144, (int)12);
            fRender.func_175065_a(turretName, (float)(17 - marquee), 9.0f, -5592321, false);
            GL11.glDisable((int)3089);
        } else {
            fRender.func_175065_a(turretName, (float)(176 - fRender.func_78256_a(turretName)) / 2.0f, 9.0f, -5592321, false);
        }
    }

    void onButtonClick(IGuiTcuInst<?> gui, GuiButton button) {
        ResourceLocation location = this.tabs.get(button);
        if (location != null) {
            TurretModRebirth.proxy.openGui((EntityPlayer)((GuiScreen)gui.getGui()).field_146297_k.field_71439_g, EnumGui.GUI_TCU, gui.getTurretInst().getEntity().func_145782_y(), GuiTcuRegistry.GUI_RESOURCES.indexOf(location), 0);
        } else if (button == this.tabNavLeft && currTabScroll > 0) {
            --currTabScroll;
        } else if (button == this.tabNavRight && currTabScroll < this.tabs.size() - 5) {
            ++currTabScroll;
        }
    }

    public static void initialize(IGuiTcuRegistry registry) {
        registry.registerGui(GuiTcuRegistry.GUI_INFO, new ItemStack(Items.field_151122_aG), GuiInfo::new, null);
        registry.registerGui(GuiTcuRegistry.GUI_TARGETS_MOB, new ItemStack(Items.field_151144_bL, 1, 2), GuiTargetCreatures::new, IGuiTcuInst::hasPermision);
        registry.registerGui(GuiTcuRegistry.GUI_TARGETS_PLAYER, PlayerHeads::getRandomSkull, GuiTargetPlayers::new, IGuiTcuInst::hasPermision);
        registry.registerGui(GuiTcuRegistry.GUI_TARGETS_SMART, UpgradeRegistry.INSTANCE.getUpgradeItem(Upgrades.SMART_TGT), GuiSmartTargets::new, GuiSmartTargets::showTab);
        registry.registerGui(GuiTcuRegistry.GUI_UPGRADES, new ItemStack((Item)ItemRegistry.TURRET_UPGRADE), GuiUpgrades::new, IGuiTcuInst::hasPermision);
    }

    private static final class ComparatorTabButton
    implements Comparator<GuiButton> {
        private ComparatorTabButton() {
        }

        @Override
        public int compare(GuiButton o1, GuiButton o2) {
            return Integer.compare(o1.field_146127_k, o2.field_146127_k);
        }
    }
}

