/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.label;

import de.sanandrew.mods.sanlib.lib.ColorObj;
import de.sanandrew.mods.turretmod.api.client.tcu.ILabelElement;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.util.Lang;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LabelTurretAmmo
implements ILabelElement {
    @Override
    public boolean showElement(ITurretInst turretInst) {
        return true;
    }

    @Override
    public float getHeight(ITurretInst turretInst, FontRenderer stdFontRenderer) {
        return (float)stdFontRenderer.field_78288_b + 6.0f;
    }

    @Override
    public float getWidth(ITurretInst turretInst, FontRenderer stdFontRenderer) {
        return stdFontRenderer.func_78256_a(LabelTurretAmmo.getLabel(turretInst));
    }

    @Override
    public void doRenderQuads(ITurretInst turretInst, float maxWidth, float progress, FontRenderer stdFontRenderer, float currHeight, VertexBuffer tessBuffer) {
        float ammoPerc = (float)turretInst.getTargetProcessor().getAmmoCount() / (float)turretInst.getTargetProcessor().getMaxAmmoCapacity() * maxWidth;
        LabelTurretAmmo.addQuad(tessBuffer, 0.0, currHeight += (float)stdFontRenderer.field_78288_b + 2.0f, ammoPerc, (double)currHeight + 2.0, new ColorObj(0.625f, 0.625f, 1.0f, Math.max(progress, 0.015686275f)));
        LabelTurretAmmo.addQuad(tessBuffer, ammoPerc, currHeight, maxWidth, (double)currHeight + 2.0, new ColorObj(0.05f, 0.05f, 0.4f, Math.max(progress, 0.015686275f)));
    }

    @Override
    public void doRenderTextured(ITurretInst turretInst, float maxWidth, float progress, FontRenderer stdFontRenderer) {
        stdFontRenderer.func_175065_a(LabelTurretAmmo.getLabel(turretInst), 0.0f, 0.0f, new ColorObj(0.625f, 0.625f, 1.0f, Math.max(progress, 0.015686275f)).getColorInt(), false);
    }

    private static String getLabel(ITurretInst turretInst) {
        return Lang.translate(Lang.TCU_LABEL_AMMO, String.format("%d/%d", turretInst.getTargetProcessor().getAmmoCount(), turretInst.getTargetProcessor().getMaxAmmoCapacity()));
    }

    private static void addQuad(VertexBuffer buf, double minX, double minY, double maxX, double maxY, ColorObj clr) {
        buf.func_181662_b(minX, minY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
        buf.func_181662_b(minX, maxY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
        buf.func_181662_b(maxX, maxY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
        buf.func_181662_b(maxX, minY, 0.0).func_181666_a(clr.fRed(), clr.fGreen(), clr.fBlue(), clr.fAlpha()).func_181675_d();
    }
}

