/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.page;

import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTCU;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.turret.ITargetProcessor;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.gui.control.GuiButtonIcon;
import de.sanandrew.mods.turretmod.client.render.world.RenderTurretCam;
import de.sanandrew.mods.turretmod.network.PacketPlayerTurretAction;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketTurretNaming;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.io.IOException;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiInfo
implements IGuiTCU {
    private int specOwnerHead;
    private FontRenderer frAmmoItem;
    private GuiButton dismantle;
    private GuiButton setActive;
    private GuiButton setDeactive;
    private GuiButton showRange;
    private GuiButton hideRange;
    private GuiTextField turretName;
    private String infoStr;
    private long infoTimeShown;

    @Override
    public void initGui(IGuiTcuInst<?> gui) {
        this.specOwnerHead = MiscUtils.RNG.randomInt(3) == 0 ? MiscUtils.RNG.randomInt(5) : 0;
        this.frAmmoItem = new FontRenderer(((GuiScreen)gui.getGui()).field_146297_k.field_71474_y, new ResourceLocation("textures/font/ascii.png"), ((GuiScreen)gui.getGui()).field_146297_k.func_110434_K(), true);
        int center = gui.getPosX() + (gui.getWidth() - 56) / 2;
        int btnY = gui.getPosY() + 190;
        if (gui.hasPermision()) {
            this.dismantle = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), center, btnY, 176, 50, Resources.GUI_TCU_INFO.getResource(), Lang.translate(Lang.TCU_BTN.get("dismantle"), new Object[0])));
            this.setActive = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), center + 19, btnY, 194, 50, Resources.GUI_TCU_INFO.getResource(), Lang.translate(Lang.TCU_BTN.get("activate"), new Object[0])));
            this.setDeactive = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), center + 19, btnY, 212, 50, Resources.GUI_TCU_INFO.getResource(), Lang.translate(Lang.TCU_BTN.get("deactivate"), new Object[0])));
            this.showRange = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), center + 38, btnY, 176, 86, Resources.GUI_TCU_INFO.getResource(), Lang.translate(Lang.TCU_BTN.get("show_range"), new Object[0])));
            this.hideRange = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), center + 38, btnY, 194, 86, Resources.GUI_TCU_INFO.getResource(), Lang.translate(Lang.TCU_BTN.get("hide_range"), new Object[0])));
        }
        this.setActive.field_146125_m = false;
        this.hideRange.field_146125_m = false;
        this.turretName = new GuiTextField(0, gui.getFontRenderer(), gui.getPosX() + 20, gui.getPosY() + 91, 148, 10);
        this.turretName.func_146203_f(128);
        this.turretName.func_146180_a(gui.getTurretInst().getEntity().func_145818_k_() ? gui.getTurretInst().getEntity().func_95999_t() : "");
    }

    @Override
    public void updateScreen(IGuiTcuInst<?> gui) {
        this.turretName.func_146178_a();
        ITurretInst turretInst = gui.getTurretInst();
        this.setDeactive.field_146125_m = turretInst.isActive();
        this.setActive.field_146125_m = !this.setDeactive.field_146125_m;
        this.hideRange.field_146125_m = turretInst.showRange();
        this.showRange.field_146125_m = !this.hideRange.field_146125_m;
    }

    @Override
    public void drawBackground(IGuiTcuInst<?> gui, float partialTicks, int mouseX, int mouseY) {
        int rgt;
        ITurretInst turretInst = gui.getTurretInst();
        FontRenderer fontRenderer = gui.getFontRenderer();
        Object guiScreen = gui.getGui();
        int posX = gui.getPosX();
        int posY = gui.getPosY();
        ((GuiScreen)guiScreen).field_146297_k.field_71446_o.func_110577_a(Resources.GUI_TCU_INFO.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiScreen.func_73729_b(posX, posY, 0, 0, gui.getWidth(), gui.getHeight());
        guiScreen.func_73729_b(posX + (gui.getWidth() - 50) / 2, posY + 39, 176, 0, 50, 50);
        gui.drawGradient(posX + 7, posY + 92, posX + 169, posY + 100, 0x10000000, 0x10000000);
        gui.drawGradient(posX + 7, posY + 104, posX + 169, posY + 112, 0x10000000, 0x10000000);
        gui.drawGradient(posX + 7, posY + 116, posX + 169, posY + 124, 0x10000000, 0x10000000);
        gui.drawGradient(posX + 7, posY + 128, posX + 169, posY + 136, 0x10000000, 0x10000000);
        gui.drawGradient(posX + 7, posY + 140, posX + 169, posY + 148, 0x10000000, 0x10000000);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiScreen.func_73729_b(posX + 7, posY + 92, 245, 0, 11, 8);
        guiScreen.func_73729_b(posX + 7, posY + 104, 245, 8, 11, 8);
        guiScreen.func_73729_b(posX + 7, posY + 116, 245, 16, 11, 8);
        guiScreen.func_73729_b(posX + 7, posY + 128, 234, this.specOwnerHead * 8, 11, 8);
        guiScreen.func_73729_b(posX + 7, posY + 140, 245, 24, 11, 8);
        EntityLiving turretL = turretInst.getEntity();
        ITargetProcessor tgtProc = turretInst.getTargetProcessor();
        String value = String.format("%.1f / %.1f HP", Float.valueOf(turretL.func_110143_aJ()), Float.valueOf(turretL.func_110138_aP()));
        fontRenderer.func_78276_b(value, posX + 20, posY + 104, -16777216);
        if (tgtProc.hasAmmo()) {
            value = String.format("%dx %s", tgtProc.getAmmoCount(), tgtProc.getAmmoStack().func_82833_r());
            if (fontRenderer.func_78256_a(value) > 139) {
                rgt = 139 - fontRenderer.func_78256_a("...");
                fontRenderer.func_78276_b("...", posX + 30 + rgt, posY + 116, -16777216);
                GL11.glEnable((int)3089);
                GuiUtils.glScissor((int)(posX + 20), (int)(posY + 116), (int)(9 + rgt), (int)8);
                fontRenderer.func_78276_b(value, posX + 30, posY + 116, -16777216);
                GL11.glDisable((int)3089);
            } else {
                fontRenderer.func_78276_b(value, posX + 30, posY + 116, -16777216);
            }
            RenderUtils.renderStackInGui((ItemStack)tgtProc.getAmmoStack(), (int)(posX + 20), (int)(posY + 116), (double)0.5, (FontRenderer)this.frAmmoItem, (String)"", (boolean)true);
        } else {
            fontRenderer.func_78276_b("-n/a-", posX + 20, posY + 116, -16777216);
        }
        value = turretInst.getOwnerName();
        fontRenderer.func_78276_b(value, posX + 20, posY + 128, -16777216);
        String string = value = tgtProc.hasTarget() ? Lang.translate(Lang.ENTITY_NAME.get(tgtProc.getTargetName()), new Object[0]) : "-n/a-";
        if (fontRenderer.func_78256_a(value) > 149) {
            rgt = 148 - fontRenderer.func_78256_a("...");
            fontRenderer.func_78276_b("...", posX + 21 + rgt, posY + 140, -16777216);
            GL11.glEnable((int)3089);
            GuiUtils.glScissor((int)(posX + 20), (int)(posY + 140), (int)rgt, (int)8);
            fontRenderer.func_78276_b(value, posX + 20, posY + 140, -16777216);
            GL11.glDisable((int)3089);
        } else {
            fontRenderer.func_78276_b(value, posX + 20, posY + 140, -16777216);
        }
        if (this.infoStr != null && this.infoTimeShown >= System.currentTimeMillis() - 5000L) {
            String err = Lang.translate(this.infoStr, new Object[0]);
            fontRenderer.func_78279_b(err, posX + 10 + (gui.getWidth() - 20 - Math.min(gui.getWidth() - 20, fontRenderer.func_78256_a(err))) / 2, posY + 160, gui.getWidth() - 25, -65536);
        } else {
            this.infoStr = null;
        }
        this.turretName.func_146194_f();
    }

    @Override
    public void drawForeground(IGuiTcuInst<?> gui, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderTurretCam.drawTurretCam(gui.getTurretInst(), 48, (gui.getWidth() - 48) / 2, 40, 48, 48);
    }

    @Override
    public void onButtonClick(IGuiTcuInst<?> gui, GuiButton button) throws IOException {
        ITurretInst turretInst = gui.getTurretInst();
        if (button == this.dismantle) {
            if (!PacketPlayerTurretAction.tryDismantle((EntityPlayer)((GuiScreen)gui.getGui()).field_146297_k.field_71439_g, turretInst)) {
                this.infoStr = Lang.TCU_DISMANTLE_ERROR.get();
                this.infoTimeShown = System.currentTimeMillis();
            } else {
                this.infoStr = null;
                ((GuiScreen)gui.getGui()).field_146297_k.field_71439_g.func_71053_j();
            }
        } else if (button == this.showRange) {
            turretInst.setShowRange(true);
            turretInst.getEntity().field_70158_ak = true;
        } else if (button == this.hideRange) {
            turretInst.setShowRange(false);
            turretInst.getEntity().field_70158_ak = false;
        } else if (button == this.setActive) {
            PacketRegistry.sendToServer((IMessage)new PacketPlayerTurretAction(turretInst, 0));
        } else if (button == this.setDeactive) {
            PacketRegistry.sendToServer((IMessage)new PacketPlayerTurretAction(turretInst, 2));
        }
    }

    @Override
    public void onMouseClick(IGuiTcuInst<?> gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        this.turretName.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean doKeyIntercept(IGuiTcuInst<?> gui, char typedChar, int keyCode) throws IOException {
        return this.turretName.func_146201_a(typedChar, keyCode);
    }

    @Override
    public void onGuiClose(IGuiTcuInst<?> gui) {
        PacketRegistry.sendToServer((IMessage)new PacketTurretNaming(gui.getTurretInst(), this.turretName.func_146179_b()));
    }
}

