/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tcu.page;

import de.sanandrew.mods.sanlib.lib.client.util.GuiUtils;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTCU;
import de.sanandrew.mods.turretmod.api.client.tcu.IGuiTcuInst;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.gui.control.GuiButtonIcon;
import de.sanandrew.mods.turretmod.network.PacketRegistry;
import de.sanandrew.mods.turretmod.network.PacketUpdateTargets;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiTargets<T>
implements IGuiTCU {
    protected static final int MAX_ITEMS = 13;
    protected SortedMap<T, Boolean> tempTargets = new TreeMap<T, Boolean>();
    protected SortedMap<T, Boolean> filteredTargets = new TreeMap<T, Boolean>();
    private float scroll = 0.0f;
    private float scrollAmount = 0.0f;
    private boolean isScrolling;
    private boolean canScroll;
    private boolean prevIsLmbDown;
    protected GuiButton whitelist;
    protected GuiButton blacklist;
    protected GuiButton selectAll;
    protected GuiButton deselectAll;
    private GuiTextField searchBar;

    @Override
    public void initGui(IGuiTcuInst<?> gui) {
        this.whitelist = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 7, gui.getPosY() + 190, 184, 0, Resources.GUI_TCU_TARGETS.getResource(), Lang.translate(Lang.TCU_BTN.get("whitelist"), new Object[0])));
        this.blacklist = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 7, gui.getPosY() + 190, 202, 0, Resources.GUI_TCU_TARGETS.getResource(), Lang.translate(Lang.TCU_BTN.get("blacklist"), new Object[0])));
        this.selectAll = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 26, gui.getPosY() + 190, 220, 0, Resources.GUI_TCU_TARGETS.getResource(), Lang.translate(Lang.TCU_BTN.get("select_all"), new Object[0])));
        this.deselectAll = gui.addNewButton(new GuiButtonIcon(gui.getNewButtonId(), gui.getPosX() + 45, gui.getPosY() + 190, 238, 0, Resources.GUI_TCU_TARGETS.getResource(), Lang.translate(Lang.TCU_BTN.get("deselect_all"), new Object[0])));
        this.searchBar = new GuiTextField(0, gui.getFontRenderer(), gui.getPosX() + 8, gui.getPosY() + 40, 160, 10);
        this.searchBar.func_146203_f(1024);
        this.searchBar.func_146180_a("");
        this.updateList(gui.getTurretInst());
    }

    @Override
    public void updateScreen(IGuiTcuInst<?> gui) {
        this.blacklist.field_146125_m = this.blacklist.field_146124_l = this.isBlacklist(gui.getTurretInst());
        this.whitelist.field_146124_l = !this.blacklist.field_146125_m;
        this.whitelist.field_146125_m = this.whitelist.field_146124_l;
        this.canScroll = this.filteredTargets.size() > 13;
        this.scrollAmount = Math.max(0.0f, 1.0f / ((float)this.filteredTargets.size() - 13.0f));
        this.searchBar.func_146178_a();
    }

    @Override
    public void drawBackground(IGuiTcuInst<?> gui, float partialTicks, int mouseX, int mouseY) {
        boolean isLmbDown = Mouse.isButtonDown((int)0);
        int scrollHeight = 129;
        int scrollAreaX = gui.getPosX() + 8;
        int scrollAreaY = gui.getPosY() + 53;
        int scrollAreaWidth = 153;
        int scrollAreaHeight = 135;
        int scrollBarMinX = gui.getPosX() + 162;
        int scrollBarMaxX = scrollBarMinX + 9;
        int scrollBarMaxY = scrollAreaY + scrollAreaHeight;
        Object guiInst = gui.getGui();
        if (!this.isScrolling && this.canScroll && isLmbDown && mouseX >= scrollBarMinX && mouseX < scrollBarMaxX && mouseY > scrollAreaY && mouseY < scrollBarMaxY) {
            this.isScrolling = true;
        } else if (!isLmbDown) {
            this.isScrolling = false;
        }
        if (this.isScrolling) {
            this.scroll = Math.max(0.0f, Math.min(1.0f, (float)(mouseY - 2 - scrollAreaY) / (float)scrollHeight));
        }
        ((GuiScreen)gui.getGui()).field_146297_k.field_71446_o.func_110577_a(Resources.GUI_TCU_TARGETS.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiInst.func_73729_b(gui.getPosX(), gui.getPosY(), 0, 0, gui.getWidth(), gui.getHeight());
        guiInst.func_73729_b(scrollBarMinX, scrollAreaY + MathHelper.func_76141_d((float)(this.scroll * (float)scrollHeight)), 176, this.canScroll ? 0 : 6, 6, 6);
        GL11.glEnable((int)3089);
        GuiUtils.glScissor((int)scrollAreaX, (int)scrollAreaY, (int)scrollAreaWidth, (int)scrollAreaHeight);
        int currScrollInd = Math.round(-this.scroll * (float)(this.filteredTargets.size() - 13));
        int offsetY = currScrollInd * (gui.getFontRenderer().field_78288_b + 1);
        int btnMinOffY = scrollAreaY + 1;
        int btnMaxOffY = btnMinOffY + 13 * (gui.getFontRenderer().field_78288_b + 1);
        boolean targetListChanged = false;
        int currInd = 0;
        for (Map.Entry<T, Boolean> entry : this.filteredTargets.entrySet()) {
            int btnTexOffY = 12 + (entry.getValue() != false ? 16 : 0);
            if (currInd++ % 2 == 1) {
                gui.drawGradient(scrollAreaX + 1, scrollAreaY + 1 + offsetY, scrollAreaX + scrollAreaWidth - 2, scrollAreaY + 9 + offsetY, 0x10000000, 0x10000000);
            }
            if (mouseY >= btnMinOffY && mouseY < btnMaxOffY && mouseX >= scrollAreaX + 1 && mouseX < scrollAreaX + scrollAreaWidth - 2 && mouseY >= scrollAreaY + 1 + offsetY && mouseY < scrollAreaY + 9 + offsetY) {
                btnTexOffY += 8;
                if (isLmbDown && !this.prevIsLmbDown) {
                    this.updateEntry(gui.getTurretInst(), entry.getKey(), entry.getValue() == false);
                    targetListChanged = true;
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ((GuiScreen)guiInst).field_146297_k.field_71446_o.func_110577_a(Resources.GUI_TCU_TARGETS.getResource());
            guiInst.func_73729_b(scrollAreaX + 1, scrollAreaY + 1 + offsetY, 176, btnTexOffY, 8, 8);
            this.drawEntry(gui, entry.getKey(), scrollAreaX + 10, scrollAreaY + 1 + offsetY);
            offsetY += gui.getFontRenderer().field_78288_b + 1;
        }
        GL11.glDisable((int)3089);
        if (targetListChanged) {
            this.updateTargets(gui.getTurretInst());
        }
        this.prevIsLmbDown = isLmbDown;
        this.searchBar.func_146194_f();
    }

    @Override
    public void onMouseInput(IGuiTcuInst<?> gui) throws IOException {
        if (this.canScroll) {
            int dWheelDir = Mouse.getEventDWheel();
            if (dWheelDir < 0) {
                this.scroll = Math.min(1.0f, this.scroll + this.scrollAmount);
            } else if (dWheelDir > 0) {
                this.scroll = Math.max(0.0f, this.scroll - this.scrollAmount);
            }
        }
    }

    @Override
    public void onButtonClick(IGuiTcuInst<?> gui, GuiButton button) throws IOException {
        if (button == this.selectAll) {
            this.tempTargets.forEach((key, val) -> this.updateEntry(gui.getTurretInst(), key, true));
            this.updateTargets(gui.getTurretInst());
        } else if (button == this.deselectAll) {
            this.tempTargets.forEach((key, val) -> this.updateEntry(gui.getTurretInst(), key, false));
            this.updateTargets(gui.getTurretInst());
        } else if (button == this.whitelist) {
            this.setBlacklist(gui.getTurretInst(), true);
            this.updateTargets(gui.getTurretInst());
        } else if (button == this.blacklist) {
            this.setBlacklist(gui.getTurretInst(), false);
            this.updateTargets(gui.getTurretInst());
        }
    }

    @Override
    public void onMouseClick(IGuiTcuInst<?> gui, int mouseX, int mouseY, int mouseButton) throws IOException {
        this.searchBar.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean doKeyIntercept(IGuiTcuInst<?> gui, char typedChar, int keyCode) throws IOException {
        if (this.searchBar.func_146201_a(typedChar, keyCode)) {
            this.filterList();
            this.scroll = 0.0f;
            return true;
        }
        return false;
    }

    protected void updateTargets(ITurretInst turretInst) {
        PacketRegistry.sendToServer((IMessage)new PacketUpdateTargets(turretInst.getTargetProcessor()));
        this.updateList(turretInst);
    }

    private void updateList(ITurretInst turretInst) {
        this.tempTargets = this.getTargetList(turretInst);
        this.filterList();
    }

    private void filterList() {
        this.filteredTargets = new TreeMap<T, Boolean>(this.tempTargets.comparator());
        this.tempTargets.entrySet().stream().filter(e -> this.isEntryVisible(e.getKey(), this.searchBar.func_146179_b())).forEach(e -> {
            Boolean cfr_ignored_0 = (Boolean)this.filteredTargets.put((T)e.getKey(), (Boolean)e.getValue());
        });
    }

    protected abstract SortedMap<T, Boolean> getTargetList(ITurretInst var1);

    protected abstract void updateEntry(ITurretInst var1, T var2, boolean var3);

    protected abstract boolean isEntryVisible(T var1, String var2);

    protected abstract void drawEntry(IGuiTcuInst<?> var1, T var2, int var3, int var4);

    protected abstract boolean isBlacklist(ITurretInst var1);

    protected abstract void setBlacklist(ITurretInst var1, boolean var2);
}

