/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo;

import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoCategory;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoCategoryRegistry;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoEntry;
import de.sanandrew.mods.turretmod.block.BlockRegistry;
import de.sanandrew.mods.turretmod.client.gui.tinfo.TurretInfoCategory;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryAmmo;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryGenerator;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryInfo;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryMiscAssembleable;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryMiscCraftable;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryTurret;
import de.sanandrew.mods.turretmod.client.gui.tinfo.entry.TurretInfoEntryUpgrade;
import de.sanandrew.mods.turretmod.item.ItemRegistry;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.turret.TurretRegistry;
import de.sanandrew.mods.turretmod.registry.upgrades.UpgradeRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class TurretInfoCategoryRegistry
implements ITurretInfoCategoryRegistry {
    private static final List<ITurretInfoCategory> CATEGORIES = new ArrayList<ITurretInfoCategory>();
    public static final TurretInfoCategoryRegistry INSTANCE = new TurretInfoCategoryRegistry();

    private TurretInfoCategoryRegistry() {
    }

    @Override
    public ITurretInfoCategory registerCategory(ResourceLocation categoryIcon, String title) {
        int ind = CATEGORIES.size();
        TurretInfoCategory cat = new TurretInfoCategory(ind, categoryIcon, title);
        CATEGORIES.add(ind, cat);
        return cat;
    }

    public static void initialize(ITurretInfoCategoryRegistry registry) {
        ITurretInfoEntry[] entries = (ITurretInfoEntry[])TurretRegistry.INSTANCE.getTurrets().stream().map(TurretInfoEntryTurret::new).toArray(ITurretInfoEntry[]::new);
        registry.registerCategory(Resources.TINFO_GRP_TURRET.getResource(), Lang.TINFO_CATEGORY_NAME.get("turrets")).addEntry(entries);
        entries = (ITurretInfoEntry[])AmmunitionRegistry.INSTANCE.getGroups().stream().map(TurretInfoEntryAmmo::new).toArray(ITurretInfoEntry[]::new);
        registry.registerCategory(Resources.TINFO_GRP_AMMO.getResource(), Lang.TINFO_CATEGORY_NAME.get("ammo")).addEntry(entries);
        entries = (ITurretInfoEntry[])UpgradeRegistry.INSTANCE.getUpgrades().stream().map(TurretInfoEntryUpgrade::new).toArray(ITurretInfoEntry[]::new);
        registry.registerCategory(Resources.TINFO_GRP_UPGRADE.getResource(), Lang.TINFO_CATEGORY_NAME.get("upgrades")).addEntry(new TurretInfoEntryMiscAssembleable(new ItemStack((Item)ItemRegistry.ASSEMBLY_UPG_AUTO))).addEntry(new TurretInfoEntryMiscAssembleable(new ItemStack((Item)ItemRegistry.ASSEMBLY_UPG_FILTER))).addEntry(new TurretInfoEntryMiscAssembleable(new ItemStack((Item)ItemRegistry.ASSEMBLY_UPG_SPEED))).addEntry(entries);
        registry.registerCategory(Resources.TINFO_GRP_MISC.getResource(), Lang.TINFO_CATEGORY_NAME.get("misc")).addEntry(new TurretInfoEntryMiscCraftable(TurretInfoCategoryRegistry.getRecipe(new ItemStack((Block)BlockRegistry.TURRET_ASSEMBLY)))).addEntry(new TurretInfoEntryGenerator(TurretInfoCategoryRegistry.getRecipe(new ItemStack((Block)BlockRegistry.ELECTROLYTE_GENERATOR)))).addEntry(new TurretInfoEntryMiscAssembleable(new ItemStack((Item)ItemRegistry.TURRET_CONTROL_UNIT)));
        registry.registerCategory(Resources.TINFO_GRP_INFO.getResource(), Lang.TINFO_CATEGORY_NAME.get("info")).addEntry(new TurretInfoEntryInfo());
    }

    @Override
    public ITurretInfoCategory[] getCategories() {
        return CATEGORIES.toArray(new ITurretInfoCategory[CATEGORIES.size()]);
    }

    @Override
    public ITurretInfoCategory getCategory(int index) {
        return CATEGORIES.get(index);
    }

    @Override
    public int getCategoryCount() {
        return CATEGORIES.size();
    }

    private static IRecipe getRecipe(ItemStack stack) {
        for (IRecipe rcp : CraftingManager.func_77594_a().func_77592_b()) {
            if (rcp == null || !ItemStackUtils.isValid((ItemStack)rcp.func_77571_b()) || !ItemStackUtils.areEqual((ItemStack)rcp.func_77571_b(), (ItemStack)stack, (boolean)false, (boolean)false, (boolean)false)) continue;
            return rcp;
        }
        return null;
    }
}

