/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.turretmod.api.ammo.IAmmunition;
import de.sanandrew.mods.turretmod.api.client.turretinfo.IGuiTurretInfo;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoEntry;
import de.sanandrew.mods.turretmod.client.shader.ShaderGrayscale;
import de.sanandrew.mods.turretmod.registry.ammo.AmmunitionRegistry;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TurretInfoEntryAmmo
implements ITurretInfoEntry {
    private static final ShaderGrayscale SHADER_GRAYSCALE = new ShaderGrayscale(TextureMap.field_110575_b);
    private int drawHeight;
    private int shownAmmo;
    private List<GuiButtonAmmoItem> ammoBtn;
    private long lastTimestamp;
    private IGuiTurretInfo guiInfo;
    private final ItemStack icon;
    private final String title;
    private final IAmmunition[] ammos;

    public TurretInfoEntryAmmo(UUID groupId) {
        IAmmunition[] ammos = AmmunitionRegistry.INSTANCE.getTypes(groupId);
        this.ammos = ammos;
        this.title = ammos[0].getInfoName();
        this.icon = this.ammos[0].getStoringAmmoItem();
    }

    @Override
    @Nonnull
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public String getTitle() {
        return Lang.TINFO_ENTRY_AMMO_NAME.get(this.title);
    }

    @Override
    public void initEntry(IGuiTurretInfo gui) {
        this.guiInfo = gui;
        this.ammoBtn = new ArrayList<GuiButtonAmmoItem>(MathHelper.func_76143_f((double)((double)this.ammos.length * 1.3333333333333333)));
        this.shownAmmo = 0;
        for (int i = 0; i < this.ammos.length; ++i) {
            GuiButtonAmmoItem btn = new GuiButtonAmmoItem(gui.__getButtons().size(), gui.getEntryX() + i * 16, gui.getEntryY(), i);
            this.ammoBtn.add(btn);
            btn.field_146124_l = i != this.shownAmmo;
            gui.__getButtons().add(btn);
        }
    }

    @Override
    public void drawPage(int mouseX, int mouseY, int scrollY, float partTicks) {
        IAmmunition ammo = this.ammos[this.shownAmmo];
        Minecraft mc = this.guiInfo.__getMc();
        ItemStack ammoItem = AmmunitionRegistry.INSTANCE.getAmmoItem(ammo);
        mc.field_71466_p.func_78276_b(TextFormatting.ITALIC + Lang.translate(this.getTitle(), new Object[0]), 2, 20, -16744261);
        Gui.func_73734_a((int)2, (int)30, (int)166, (int)31, (int)-16744261);
        mc.func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiInfo.__drawTexturedRect(2, 34, 192, 18, 34, 34);
        this.guiInfo.renderStack(ammoItem, 3, 35, 2.0);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_ROUNDS, new Object[0]), 42.0f, 34.0f, -9803158, false);
        mc.field_71466_p.func_175065_a(String.format("%d", ammo.getAmmoCapacity()), 45.0f, 43.0f, -16777216, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_DPS, new Object[0]), 42.0f, 54.0f, -9803158, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_HEALTHVAL, Float.valueOf(ammo.getInfoDamage())), 45.0f, 63.0f, -16777216, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_TURRET, new Object[0]), 42.0f, 74.0f, -9803158, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TURRET_NAME.get(ammo.getTurret().getName()), new Object[0]), 45.0f, 83.0f, -16777216, false);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_CRAFTING, new Object[0]), 42.0f, 94.0f, -9803158, false);
        String text = Lang.translate(Lang.TINFO_ENTRY_AMMO_DESC.get(ammo.getInfoName()), new Object[0]).replace("\\n", "\n");
        mc.field_71466_p.func_78279_b(text, 2, 117, 166, -16777216);
        this.drawHeight = mc.field_71466_p.func_78267_b(text, 166) + 2;
        Gui.func_73734_a((int)2, (int)114, (int)166, (int)115, (int)-16744261);
        TurretAssemblyRegistry.RecipeEntry recipeEntry = TurretAssemblyRegistry.INSTANCE.getRecipeEntry(ammoItem);
        if (recipeEntry != null) {
            for (int i = 0; i < recipeEntry.resources.length; ++i) {
                ItemStack[] stacks = recipeEntry.resources[i].getEntryItemStacks();
                this.guiInfo.drawMiniItem(45 + 10 * i, 103, mouseX, mouseY, scrollY, stacks[(int)(this.lastTimestamp / 1000L % (long)stacks.length)], recipeEntry.resources[i].shouldDrawTooltip());
            }
        }
        this.drawHeight += 116;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
        Gui.func_73734_a((int)0, (int)scrollY, (int)168, (int)(16 + scrollY), (int)Integer.MIN_VALUE);
        GlStateManager.func_179121_F();
        long time = System.currentTimeMillis();
        if (this.lastTimestamp + 1000L < time) {
            this.lastTimestamp = time;
        }
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }

    @Override
    public boolean actionPerformed(GuiButton btn) {
        if (btn instanceof GuiButtonAmmoItem) {
            this.shownAmmo = ((GuiButtonAmmoItem)btn).ammoIndex;
            this.ammoBtn.forEach(ammoBtnInst -> {
                ammoBtnInst.field_146124_l = ammoBtnInst.ammoIndex != this.shownAmmo;
            });
            return true;
        }
        return false;
    }

    private class GuiButtonAmmoItem
    extends GuiButton {
        public final int ammoIndex;
        @Nonnull
        public final ItemStack stack;

        public GuiButtonAmmoItem(int id, int x, int y, int index) {
            super(id, x, y, 16, 16, "");
            this.ammoIndex = index;
            this.stack = AmmunitionRegistry.INSTANCE.getAmmoItem(TurretInfoEntryAmmo.this.ammos[this.ammoIndex]);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
                Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + 1), (int)-1610612736);
                Gui.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + this.field_146121_g - 1), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-1610612736);
                Gui.func_73734_a((int)this.field_146128_h, (int)(this.field_146129_i + 1), (int)(this.field_146128_h + 1), (int)(this.field_146129_i + this.field_146121_g - 1), (int)0x40000000);
                Gui.func_73734_a((int)(this.field_146128_h + this.field_146120_f - 1), (int)(this.field_146129_i + 1), (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g - 1), (int)0x40000000);
                if (this.field_146124_l) {
                    Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)Integer.MIN_VALUE);
                    SHADER_GRAYSCALE.render(() -> TurretInfoEntryAmmo.this.guiInfo.renderStack(this.stack, this.field_146128_h, this.field_146129_i, 1.0), 0.75f);
                } else {
                    Gui.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + this.field_146120_f), (int)(this.field_146129_i + this.field_146121_g), (int)-2130706433);
                    TurretInfoEntryAmmo.this.guiInfo.renderStack(this.stack, this.field_146128_h, this.field_146129_i, 1.0);
                }
                GlStateManager.func_179121_F();
            }
        }
    }
}

