/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.turretmod.api.client.turretinfo.IGuiTurretInfo;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoEntry;
import de.sanandrew.mods.turretmod.registry.assembly.TurretAssemblyRegistry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TurretInfoEntryMiscAssembleable
implements ITurretInfoEntry {
    private int drawHeight;
    private long lastTimestamp;
    private IGuiTurretInfo guiInfo;
    private final ItemStack icon;
    private final TurretAssemblyRegistry.RecipeEntry recipe;
    private final String title;
    private final String desc;

    public TurretInfoEntryMiscAssembleable(@Nonnull ItemStack stack) {
        this(stack, TurretAssemblyRegistry.INSTANCE.getRecipeEntry(stack));
    }

    private TurretInfoEntryMiscAssembleable(@Nonnull ItemStack stack, TurretAssemblyRegistry.RecipeEntry recipeEntry) {
        this.icon = stack;
        this.title = stack.func_77977_a() + ".name";
        this.recipe = recipeEntry;
        this.desc = stack.func_77977_a() + ".desc";
    }

    @Override
    public void initEntry(IGuiTurretInfo gui) {
        this.guiInfo = gui;
    }

    @Override
    @Nonnull
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public String getTitle() {
        return Lang.translate(this.title, new Object[0]);
    }

    @Override
    public void drawPage(int mouseX, int mouseY, int scrollY, float partTicks) {
        int infoHeight = 54;
        Minecraft mc = this.guiInfo.__getMc();
        mc.field_71466_p.func_78276_b(TextFormatting.ITALIC + Lang.translate(this.title, new Object[0]), 2, 2, -16744261);
        Gui.func_73734_a((int)2, (int)12, (int)166, (int)13, (int)-16744261);
        mc.func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiInfo.__drawTexturedRect(2, 16, 192, 18, 34, 34);
        RenderUtils.renderStackInGui((ItemStack)this.icon, (int)3, (int)17, (double)2.0);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_CRAFTING.get(), new Object[0]), 42.0f, 16.0f, -9803158, false);
        Gui.func_73734_a((int)2, (int)infoHeight, (int)166, (int)(infoHeight + 1), (int)-16744261);
        String text = Lang.translate(this.desc, new Object[0]).replace("\\n", "\n");
        mc.field_71466_p.func_78279_b(text, 2, infoHeight + 3, 166, -16777216);
        this.drawHeight = mc.field_71466_p.func_78267_b(text, 166) + infoHeight + 3 + 2;
        for (int i = 0; i < this.recipe.resources.length; ++i) {
            ItemStack[] stacks = this.recipe.resources[i].getEntryItemStacks();
            this.guiInfo.drawMiniItem(45 + 10 * i, 25, mouseX, mouseY, scrollY, stacks[(int)(this.lastTimestamp / 1000L % (long)stacks.length)], this.recipe.resources[i].shouldDrawTooltip());
        }
        long time = System.currentTimeMillis();
        if (this.lastTimestamp + 1000L < time) {
            this.lastTimestamp = time;
        }
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }
}

