/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.gui.tinfo.entry;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.CraftingUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.api.client.turretinfo.IGuiTurretInfo;
import de.sanandrew.mods.turretmod.api.client.turretinfo.ITurretInfoEntry;
import de.sanandrew.mods.turretmod.util.Lang;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

@SideOnly(value=Side.CLIENT)
public class TurretInfoEntryMiscCraftable
implements ITurretInfoEntry {
    private final String desc;
    private final Tuple crafting;
    private int drawHeight;
    private long lastTimestamp;
    protected IGuiTurretInfo guiInfo;
    private final ItemStack icon;
    private final String title;

    public TurretInfoEntryMiscCraftable(IRecipe recipe) {
        this(recipe != null ? recipe.func_77571_b() : ItemStackUtils.getEmpty(), recipe);
    }

    private TurretInfoEntryMiscCraftable(@Nonnull ItemStack stack, IRecipe recipe) {
        this.icon = stack;
        this.title = String.format("%s.name", stack.func_77977_a());
        this.desc = String.format("%s.desc", stack.func_77977_a());
        this.crafting = recipe != null ? (recipe instanceof ShapedOreRecipe ? TurretInfoEntryMiscCraftable.getCrafting((ShapedOreRecipe)recipe) : (recipe instanceof ShapedRecipes ? TurretInfoEntryMiscCraftable.getCrafting((ShapedRecipes)recipe) : new Tuple(new Object[]{null, 0, 0}))) : new Tuple(new Object[]{null, 0, 0});
    }

    @Override
    @Nonnull
    public ItemStack getIcon() {
        return this.icon;
    }

    @Override
    public String getTitle() {
        return Lang.translate(this.title, new Object[0]);
    }

    @Override
    public void initEntry(IGuiTurretInfo gui) {
        this.guiInfo = gui;
    }

    private static Tuple getCrafting(ShapedRecipes cRecipe) {
        ItemStack[][] crfArray = new ItemStack[cRecipe.field_77576_b * cRecipe.field_77577_c][];
        for (int i = 0; i < cRecipe.field_77577_c; ++i) {
            for (int j = 0; j < cRecipe.field_77576_b; ++j) {
                ItemStack recpStack = cRecipe.field_77574_d[i * cRecipe.field_77576_b + j];
                ItemStack[] recpStacks = null;
                if (ItemStackUtils.isValid((ItemStack)recpStack)) {
                    NonNullList stacks = NonNullList.func_191197_a((int)1, (Object)recpStack);
                    recpStacks = (ItemStack[])stacks.toArray((Object[])new ItemStack[stacks.size()]);
                }
                crfArray[i * cRecipe.field_77576_b + j] = recpStacks;
            }
        }
        return new Tuple(new Object[]{crfArray, cRecipe.field_77576_b, cRecipe.field_77577_c});
    }

    private static Tuple getCrafting(ShapedOreRecipe cRecipe) {
        int recipeWidth = CraftingUtils.getOreRecipeWidth((ShapedOreRecipe)cRecipe);
        int recipeHeight = CraftingUtils.getOreRecipeHeight((ShapedOreRecipe)cRecipe);
        ItemStack[][] crfArray = new ItemStack[recipeWidth * recipeHeight][];
        for (int i = 0; i < recipeHeight; ++i) {
            for (int j = 0; j < recipeWidth; ++j) {
                Object recpObj = cRecipe.getInput()[i * recipeWidth + j];
                ItemStack[] recpStacks = null;
                if (recpObj != null) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    if (recpObj instanceof ItemStack && ItemStackUtils.isValid((ItemStack)((ItemStack)recpObj))) {
                        ItemStack recpStack = (ItemStack)recpObj;
                        stacks.add(recpStack);
                    } else if (recpObj instanceof List) {
                        ((List)recpObj).stream().filter(input -> input != null && ItemStackUtils.isValid((ItemStack)input)).forEach(stacks::add);
                    }
                    recpStacks = stacks.toArray(new ItemStack[stacks.size()]);
                }
                crfArray[i * recipeWidth + j] = recpStacks;
            }
        }
        return new Tuple(new Object[]{crfArray, recipeWidth, recipeHeight});
    }

    @Override
    public void drawPage(int mouseX, int mouseY, int scrollY, float partTicks) {
        Minecraft mc = this.guiInfo.__getMc();
        mc.field_71466_p.func_78276_b(TextFormatting.ITALIC + Lang.translate(this.getTitle(), new Object[0]), 2, 2, -16744261);
        Gui.func_73734_a((int)2, (int)12, (int)166, (int)13, (int)-16744261);
        mc.func_110434_K().func_110577_a(Resources.GUI_TURRETINFO.getResource());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiInfo.__drawTexturedRect(2, 16, 192, 18, 34, 34);
        RenderUtils.renderStackInGui((ItemStack)this.icon, (int)3, (int)17, (double)2.0);
        mc.field_71466_p.func_175065_a(Lang.translate(Lang.TINFO_ENTRY_WORKBENCH.get(), new Object[0]), 42.0f, 16.0f, -9803158, false);
        this.drawHeight = 27 + 9 * (Integer)this.crafting.getValue(2);
        Gui.func_73734_a((int)2, (int)this.drawHeight, (int)166, (int)(this.drawHeight + 1), (int)-16744261);
        String text = Lang.translate(this.desc, new Object[0]).replace("\\n", "\n");
        mc.field_71466_p.func_78279_b(text, 2, this.drawHeight + 3, 166, -16777216);
        this.drawHeight = mc.field_71466_p.func_78267_b(text, 166) + this.drawHeight + 3 + 2;
        int maxI = (Integer)this.crafting.getValue(1);
        for (int i = 0; i < maxI; ++i) {
            int maxJ = (Integer)this.crafting.getValue(2);
            for (int j = 0; j < maxJ; ++j) {
                ItemStack[] crfStack = ((ItemStack[][])this.crafting.getValue(0))[i * 3 + j];
                ItemStack drawnStack = ItemStackUtils.getEmpty();
                if (crfStack != null && crfStack.length > 0) {
                    drawnStack = crfStack[(int)(this.lastTimestamp / 1000L % (long)crfStack.length)];
                }
                this.guiInfo.drawMiniItem(42 + 9 * j, 25 + 9 * i, mouseX, mouseY, scrollY, drawnStack, true);
            }
        }
        long time = System.currentTimeMillis();
        if (this.lastTimestamp + 1000L < time) {
            this.lastTimestamp = time;
        }
    }

    @Override
    public int getPageHeight() {
        return this.drawHeight;
    }
}

