/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.model;

import de.sanandrew.mods.sanlib.lib.client.ModelJsonHandler;
import de.sanandrew.mods.sanlib.lib.client.ModelJsonLoader;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelTurretBase
extends ModelBase
implements ModelJsonHandler<ModelTurretBase, ModelJsonLoader.ModelJson> {
    public ModelRenderer base;
    public ModelRenderer head;
    public ModelRenderer throat;
    public ModelRenderer healthBar;
    public ModelRenderer ammoBar;
    private final ModelJsonLoader<ModelTurretBase, ModelJsonLoader.ModelJson> modelJson;
    private final float scale;

    public ModelTurretBase(float scale) {
        this.scale = scale;
        this.modelJson = ModelJsonLoader.create((ModelBase)this, (ResourceLocation)this.getModelLocation(), (String[])((String[])this.getMandatoryBoxes().stream().toArray(String[]::new)));
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float rotFloat, float rotYaw, float rotPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, rotFloat, rotYaw, rotPitch, scale, entity);
        if (this.modelJson.isLoaded()) {
            Arrays.asList(this.modelJson.getMainBoxes()).forEach(box -> box.func_78785_a(scale));
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float rotFloat, float rotYaw, float rotPitch, float partTicks, Entity entity) {
        super.func_78087_a(limbSwing, limbSwingAmount, rotFloat, rotYaw, rotPitch, partTicks, entity);
        this.head.field_78796_g = rotYaw / 57.295776f;
        this.head.field_78795_f = rotPitch / 57.295776f;
        ITurretInst turret = (ITurretInst)entity;
        float maxHealth = turret.isInGui() ? 2.0f : turret.getEntity().func_110138_aP();
        float health = turret.isInGui() ? 1.0f : turret.getEntity().func_110143_aJ();
        int maxAmmo = turret.isInGui() ? 2 : turret.getTargetProcessor().getMaxAmmoCapacity();
        int ammo = turret.isInGui() ? 1 : turret.getTargetProcessor().getAmmoCount();
        this.healthBar.field_78808_h = -1.5707964f * ((maxHealth - health) / maxHealth);
        this.ammoBar.field_78808_h = 1.5707964f * ((float)(maxAmmo - ammo) / (float)maxAmmo);
    }

    public void onReload(IResourceManager iResourceManager, ModelJsonLoader<ModelTurretBase, ModelJsonLoader.ModelJson> loader) {
        loader.load();
        this.base = loader.getBox("base");
        this.throat = loader.getBox("throat");
        this.head = loader.getBox("head");
        this.healthBar = loader.getBox("healthBar");
        this.ammoBar = loader.getBox("ammoBar");
    }

    public void setTexture(String s) {
    }

    public float getBaseScale() {
        return this.scale;
    }

    public List<String> getMandatoryBoxes() {
        return Arrays.asList("base", "head", "throat", "healthBar", "ammoBar");
    }

    public ResourceLocation getModelLocation() {
        return Resources.TURRET_T1_BASE_MODEL.getResource();
    }
}

