/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.model;

import de.sanandrew.mods.sanlib.lib.client.ModelJsonLoader;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.model.ModelTurretBase;
import de.sanandrew.mods.turretmod.registry.turret.TurretMinigun;
import de.sanandrew.mods.turretmod.util.Resources;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class ModelTurretMinigun
extends ModelTurretBase {
    public ModelRenderer barrelBaseLeft;
    public ModelRenderer barrelBaseRight;

    public ModelTurretMinigun(float scale) {
        super(scale);
    }

    public void func_78086_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partTicks) {
        TurretMinigun.MyRAM ram;
        super.func_78086_a(entity, limbSwing, limbSwingAmount, partTicks);
        ITurretInst turretInst = (ITurretInst)entity;
        if (turretInst.getTurret() instanceof TurretMinigun && (ram = turretInst.getRAM(TurretMinigun.MyRAM::new)) != null) {
            float barrelDeltaL = ram.prevBarrelLeft + (ram.barrelLeft - ram.prevBarrelLeft) * partTicks;
            float barrelDeltaR = ram.prevBarrelRight + (ram.barrelRight - ram.prevBarrelRight) * partTicks;
            this.barrelBaseLeft.field_78808_h = barrelDeltaL / 180.0f * (float)Math.PI;
            this.barrelBaseRight.field_78808_h = barrelDeltaR / 180.0f * (float)Math.PI;
        }
    }

    @Override
    public List<String> getMandatoryBoxes() {
        return Stream.concat(super.getMandatoryBoxes().stream(), Stream.of("barrelBaseLeft", "barrelBaseRight")).collect(Collectors.toList());
    }

    @Override
    public void onReload(IResourceManager iResourceManager, ModelJsonLoader<ModelTurretBase, ModelJsonLoader.ModelJson> loader) {
        super.onReload(iResourceManager, loader);
        this.barrelBaseLeft = loader.getBox("barrelBaseLeft");
        this.barrelBaseRight = loader.getBox("barrelBaseRight");
    }

    @Override
    public ResourceLocation getModelLocation() {
        return Resources.TURRET_T2_MINIGUN_MODEL.getResource();
    }
}

