/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.layer;

import de.sanandrew.mods.sanlib.lib.XorShiftRandom;
import de.sanandrew.mods.sanlib.lib.util.MiscUtils;
import de.sanandrew.mods.turretmod.api.turret.ITurretInst;
import de.sanandrew.mods.turretmod.client.event.ClientTickHandler;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerTurretShieldLightning<E extends EntityLiving>
implements LayerRenderer<E> {
    private static final WeakHashMap<ITurretInst, Queue<RenderLightning>> LIGHTNING_RENDERS = new WeakHashMap();

    public void doRenderLayer(E turretInst, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        LIGHTNING_RENDERS.forEach((key, value) -> value.removeIf(RenderLightning::finished));
        LIGHTNING_RENDERS.entrySet().removeIf(entry -> ((Queue)entry.getValue()).isEmpty());
        if (((ITurretInst)turretInst).isActive() && MiscUtils.RNG.randomInt(150) == 0 && !Minecraft.func_71410_x().func_147113_T()) {
            LIGHTNING_RENDERS.computeIfAbsent((ITurretInst)turretInst, (Function<ITurretInst, Queue<RenderLightning>>)((Function<ITurretInst, Queue>)inst -> new ConcurrentLinkedQueue())).add(new RenderLightning());
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.01, (double)0.01, (double)0.01);
        GlStateManager.func_179109_b((float)0.0f, (float)-144.0f, (float)0.0f);
        float lastBrightX = OpenGlHelper.lastBrightnessX;
        float lastBrightY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)0.0f);
        LIGHTNING_RENDERS.entrySet().stream().filter(entry -> entry.getKey() == turretInst).forEach(entry -> ((Queue)entry.getValue()).forEach(val -> val.doRender(partialTicks)));
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightX, (float)lastBrightY);
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }

    private static class RenderLightning {
        private static final int MAX_TICKS_VISIBLE = 20;
        private final int ticksVisible = ClientTickHandler.ticksInGame + 20;
        private final long seed = MiscUtils.RNG.randomLong();

        public boolean finished() {
            return this.ticksVisible <= ClientTickHandler.ticksInGame;
        }

        public void doRender(float partTicks) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Tessellator tess = Tessellator.func_178181_a();
            this.renderLightning(tess, partTicks);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        }

        public void renderLightning(Tessellator tess, float partTicks) {
            double[] xPos = new double[8];
            double[] zPos = new double[8];
            double maxX = 0.0;
            double maxZ = 0.0;
            XorShiftRandom rngMain = new XorShiftRandom(this.seed);
            VertexBuffer buf = tess.func_178180_c();
            for (int i = 7; i >= 0; --i) {
                xPos[i] = maxX;
                zPos[i] = maxZ;
                maxX += (double)(rngMain.randomInt(11) - 5);
                maxZ += (double)(rngMain.randomInt(11) - 5);
            }
            for (int j = 0; j < 4; ++j) {
                XorShiftRandom rngBranch = new XorShiftRandom(this.seed);
                for (int k = 0; k < 3; ++k) {
                    int maxLvl = 7;
                    int minLvl = rngBranch.randomInt(7);
                    double minX = xPos[maxLvl] - maxX;
                    double minZ = zPos[maxLvl] - maxZ;
                    for (int level = maxLvl; level >= minLvl; --level) {
                        double xBranch = minX;
                        double zBranch = minZ;
                        if (k == 0) {
                            minX += (double)(rngBranch.randomInt(10) - 5);
                            minZ += (double)(rngBranch.randomInt(10) - 5);
                        } else {
                            minX += (double)(rngBranch.randomInt(31) - 15);
                            minZ += (double)(rngBranch.randomInt(31) - 15);
                        }
                        buf.func_181668_a(5, DefaultVertexFormats.field_181706_f);
                        double maxDither = 0.1 + (double)j * 0.2;
                        if (k == 0) {
                            maxDither *= (double)level * 0.1 + 1.0;
                        }
                        double minDither = 0.1 + (double)j * 0.2;
                        if (k == 0) {
                            minDither *= (double)(level - 1) * 0.1 + 1.0;
                        }
                        for (int k1 = 0; k1 < 5; ++k1) {
                            double xTwigMax = 0.5 - maxDither;
                            double zTwigMax = 0.5 - maxDither;
                            if (k1 == 1 || k1 == 2) {
                                xTwigMax += maxDither * 2.0;
                            }
                            if (k1 == 2 || k1 == 3) {
                                zTwigMax += maxDither * 2.0;
                            }
                            double xTwigMin = 0.5 - minDither;
                            double zTwigMin = 0.5 - minDither;
                            if (k1 == 1 || k1 == 2) {
                                xTwigMin += minDither * 2.0;
                            }
                            if (k1 == 2 || k1 == 3) {
                                zTwigMin += minDither * 2.0;
                            }
                            float lum = 0.5f;
                            float alpha = ((float)(this.ticksVisible - ClientTickHandler.ticksInGame) - partTicks) / 20.0f;
                            buf.func_181662_b(xTwigMin + minX, (double)(level * 16), zTwigMin + minZ).func_181666_a(0.9f * lum, 0.2f * lum, 0.2f * lum, alpha).func_181675_d();
                            buf.func_181662_b(xTwigMax + xBranch, (double)((level + 1) * 16), zTwigMax + zBranch).func_181666_a(0.9f * lum, 0.2f * lum, 0.2f * lum, alpha).func_181675_d();
                        }
                        tess.func_78381_a();
                    }
                }
            }
        }
    }
}

