/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.turretmod.client.render.tileentity;

import de.sanandrew.mods.sanlib.lib.Tuple;
import de.sanandrew.mods.sanlib.lib.client.util.RenderUtils;
import de.sanandrew.mods.sanlib.lib.util.ItemStackUtils;
import de.sanandrew.mods.turretmod.block.BlockRegistry;
import de.sanandrew.mods.turretmod.client.model.block.ModelTurretAssembly;
import de.sanandrew.mods.turretmod.client.shader.ShaderItemAlphaOverride;
import de.sanandrew.mods.turretmod.client.util.ShaderHelper;
import de.sanandrew.mods.turretmod.tileentity.assembly.TileEntityTurretAssembly;
import de.sanandrew.mods.turretmod.util.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTurretAssembly
extends TileEntitySpecialRenderer<TileEntityTurretAssembly> {
    private final ModelTurretAssembly modelBlock = new ModelTurretAssembly();
    public float armX;
    public float armZ;
    private final ShaderItemAlphaOverride shaderCallback = new ShaderItemAlphaOverride();

    public void func_180535_a(TileEntityTurretAssembly tile, double x, double y, double z, float partTicks, int destroyStage) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.armX = Math.max(2.0f, Math.min(12.0f, tile.prevRobotArmX + (tile.robotArmX - tile.prevRobotArmX) * partTicks)) - 7.0f;
        this.armZ = Math.max(-11.0f, Math.min(-3.0f, tile.prevRobotArmY + (tile.robotArmY - tile.prevRobotArmY) * partTicks));
        this.func_147499_a(Resources.TILE_TURRET_ASSEMBLY.getResource());
        this.modelBlock.render(0.0625f, tile, this.armX, this.armZ);
        this.renderItem(tile);
        if (tile.isActive && tile.robotArmX >= 4.0f && tile.robotArmX <= 10.0f && tile.robotArmY <= -3.5f && tile.robotArmY >= -9.5f) {
            tile.spawnParticle = this.renderLaser(BlockRegistry.TURRET_ASSEMBLY.getDirection(tile.func_145832_p()), tile.func_174877_v());
        }
        GlStateManager.func_179121_F();
    }

    private Tuple renderLaser(EnumFacing facing, BlockPos pos) {
        float laserX = this.armX / 16.0f;
        float laserZ = (this.armZ + 5.5f) / 16.0f;
        switch (facing) {
            case WEST: {
                float lx = laserX;
                laserX = laserZ;
                laserZ = -lx;
                break;
            }
            case NORTH: {
                laserX = -laserX;
                laserZ = -laserZ;
                break;
            }
            case EAST: {
                float lx = laserX;
                laserX = -laserZ;
                laserZ = lx;
            }
        }
        int tileX = pos.func_177958_n();
        int tileY = pos.func_177956_o();
        int tileZ = pos.func_177952_p();
        float dist = (float)Minecraft.func_71410_x().field_71439_g.func_70011_f((double)((float)tileX + 0.5f), (double)((float)tileY + 0.5f), (double)((float)tileZ + 0.5f));
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer buf = tess.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)laserX, (float)0.5f, (float)laserZ);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float prevBrightX = OpenGlHelper.lastBrightnessX;
        float prevBrightY = OpenGlHelper.lastBrightnessY;
        int bright = 240;
        int brightX = bright % 65536;
        int brightY = bright / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)brightX, (float)brightY);
        GlStateManager.func_187441_d((float)Math.min(20.0f, 20.0f / dist));
        buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(0.0, (double)0.1f, 0.0).func_181669_b(255, 0, 0, 64).func_181675_d();
        buf.func_181662_b(0.0, 1.0, 0.0).func_181669_b(255, 0, 0, 64).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_187441_d((float)Math.min(5.0f, 5.0f / dist));
        buf.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        buf.func_181662_b(0.0, (double)0.1f, 0.0).func_181669_b(255, 0, 0, 128).func_181675_d();
        buf.func_181662_b(0.0, 1.0, 0.0).func_181669_b(255, 0, 0, 128).func_181675_d();
        tess.func_78381_a();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)prevBrightX, (float)prevBrightY);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        return new Tuple(new Object[]{(double)((float)tileX + 0.5f + laserX), (double)((float)tileY + 0.65f), (double)((float)tileZ + 0.5f - laserZ)});
    }

    private void renderItem(TileEntityTurretAssembly assembly) {
        int xShift = 0;
        ItemStack crfStack = assembly.currCrafting != null ? (ItemStack)assembly.currCrafting.getValue(1) : assembly.getInventory().func_70301_a(0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)((float)(90.0 * (double)BlockRegistry.TURRET_ASSEMBLY.getDirection(assembly.func_145832_p()).func_176736_b())), (float)0.0f, (float)1.0f, (float)0.0f);
        if (ItemStackUtils.isValid((ItemStack)crfStack)) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.shaderCallback.alphaMulti = Math.max(0.0f, ((float)assembly.getTicksCrafted() - 15.0f) / ((float)assembly.getMaxTicksCrafted() - 15.0f));
            ShaderHelper.useShader(ShaderHelper.alphaOverride, this.shaderCallback::call);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
            RenderUtils.renderStackInWorld((ItemStack)crfStack, (double)0.0, (double)0.802, (double)0.0, (float)-90.0f, (float)180.0f, (float)0.0f, (double)0.35);
            ShaderHelper.releaseShader();
            GlStateManager.func_179084_k();
        }
        if (assembly.hasAutoUpgrade()) {
            RenderUtils.renderStackInWorld((ItemStack)assembly.getInventory().func_70301_a(1), (double)(-0.425 + (double)xShift++ * 0.025), (double)0.85, (double)-0.35, (float)0.0f, (float)90.0f, (float)0.0f, (double)0.15);
        }
        if (assembly.hasSpeedUpgrade()) {
            RenderUtils.renderStackInWorld((ItemStack)assembly.getInventory().func_70301_a(2), (double)(-0.425 + (double)xShift++ * 0.025), (double)0.85, (double)-0.35, (float)0.0f, (float)90.0f, (float)0.0f, (double)0.15);
        }
        if (assembly.hasFilterUpgrade()) {
            RenderUtils.renderStackInWorld((ItemStack)assembly.getInventory().func_70301_a(3), (double)(-0.425 + (double)xShift * 0.025), (double)0.85, (double)-0.35, (float)0.0f, (float)90.0f, (float)0.0f, (double)0.15);
        }
        GlStateManager.func_179121_F();
    }
}

